/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.websocket.server;

import jakarta.servlet.ServletContainerInitializer;
import java.util.ArrayList;
import java.util.List;
import org.citrusframework.http.server.HttpServer;
import org.citrusframework.websocket.endpoint.WebSocketEndpoint;
import org.citrusframework.websocket.servlet.CitrusWebSocketDispatcherServlet;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.springframework.web.servlet.DispatcherServlet;

public class WebSocketServer
extends HttpServer {
    private List<WebSocketEndpoint> webSockets = new ArrayList<WebSocketEndpoint>();

    public WebSocketServer() {
        this.setContextConfigLocation("classpath:org/citrusframework/websocket/citrus-servlet-context.xml");
    }

    protected DispatcherServlet getDispatcherServlet() {
        return new CitrusWebSocketDispatcherServlet(this);
    }

    protected void configure(ServletContextHandler contextHandler) {
        contextHandler.addServletContainerInitializer((ServletContainerInitializer)new JettyWebSocketServletContainerInitializer());
    }

    public void initialize() {
        super.initialize();
        for (WebSocketEndpoint webSocket : this.webSockets) {
            webSocket.setActor(this.getActor());
        }
    }

    public List<WebSocketEndpoint> getWebSockets() {
        return this.webSockets;
    }

    public void setWebSockets(List<WebSocketEndpoint> webSockets) {
        this.webSockets = webSockets;
    }
}

