/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.actions;

import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.ws.actions.SoapClientActionBuilder;
import org.citrusframework.ws.actions.SoapServerActionBuilder;
import org.citrusframework.ws.client.WebServiceClient;
import org.citrusframework.ws.server.WebServiceServer;
import org.springframework.util.Assert;

public class SoapActionBuilder
implements TestActionBuilder.DelegatingTestActionBuilder<TestAction>,
ReferenceResolverAware {
    private ReferenceResolver referenceResolver;
    private TestActionBuilder<?> delegate;

    public static SoapActionBuilder soap() {
        return new SoapActionBuilder();
    }

    public SoapClientActionBuilder client(WebServiceClient soapClient) {
        SoapClientActionBuilder clientActionBuilder = new SoapClientActionBuilder((Endpoint)soapClient).withReferenceResolver(this.referenceResolver);
        this.delegate = clientActionBuilder;
        return clientActionBuilder;
    }

    public SoapClientActionBuilder client(String soapClient) {
        SoapClientActionBuilder clientActionBuilder = new SoapClientActionBuilder(soapClient).withReferenceResolver(this.referenceResolver);
        this.delegate = clientActionBuilder;
        return clientActionBuilder;
    }

    public SoapServerActionBuilder server(WebServiceServer soapServer) {
        SoapServerActionBuilder serverActionBuilder = new SoapServerActionBuilder((Endpoint)soapServer).withReferenceResolver(this.referenceResolver);
        this.delegate = serverActionBuilder;
        return serverActionBuilder;
    }

    public SoapServerActionBuilder server(String soapServer) {
        SoapServerActionBuilder serverActionBuilder = new SoapServerActionBuilder(soapServer).withReferenceResolver(this.referenceResolver);
        this.delegate = serverActionBuilder;
        return serverActionBuilder;
    }

    public SoapActionBuilder withReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
        return this;
    }

    public TestAction build() {
        Assert.notNull(this.delegate, (String)"Missing delegate action to build");
        return this.delegate.build();
    }

    public TestActionBuilder<?> getDelegate() {
        return this.delegate;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        if (referenceResolver == null) {
            this.referenceResolver = referenceResolver;
            if (this.delegate instanceof ReferenceResolverAware) {
                ((ReferenceResolverAware)this.delegate).setReferenceResolver(referenceResolver);
            }
        }
    }
}

