/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.actions;

import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.ws.actions.ReceiveSoapMessageAction;
import org.citrusframework.ws.actions.SendSoapFaultAction;
import org.citrusframework.ws.actions.SendSoapMessageAction;
import org.springframework.util.Assert;

public class SoapServerActionBuilder
implements TestActionBuilder.DelegatingTestActionBuilder<TestAction>,
ReferenceResolverAware {
    private ReferenceResolver referenceResolver;
    private Endpoint soapServer;
    private String soapServerUri;
    private TestActionBuilder<?> delegate;

    public SoapServerActionBuilder(Endpoint soapServer) {
        this.soapServer = soapServer;
    }

    public SoapServerActionBuilder(String soapServerUri) {
        this.soapServerUri = soapServerUri;
    }

    public ReceiveSoapMessageAction.Builder receive() {
        ReceiveSoapMessageAction.Builder builder = new ReceiveSoapMessageAction.Builder();
        if (this.soapServer != null) {
            builder.endpoint(this.soapServer);
        } else {
            builder.endpoint(this.soapServerUri);
        }
        builder.name("soap:receive-request");
        builder.withReferenceResolver(this.referenceResolver);
        this.delegate = builder;
        return builder;
    }

    public SendSoapMessageAction.Builder send() {
        SendSoapMessageAction.Builder builder = new SendSoapMessageAction.Builder();
        if (this.soapServer != null) {
            builder.endpoint(this.soapServer);
        } else {
            builder.endpoint(this.soapServerUri);
        }
        builder.name("soap:send-response");
        builder.withReferenceResolver(this.referenceResolver);
        this.delegate = builder;
        return builder;
    }

    public SendSoapFaultAction.Builder sendFault() {
        SendSoapFaultAction.Builder builder = new SendSoapFaultAction.Builder();
        if (this.soapServer != null) {
            builder.endpoint(this.soapServer);
        } else {
            builder.endpoint(this.soapServerUri);
        }
        builder.name("soap:send-fault");
        builder.withReferenceResolver(this.referenceResolver);
        this.delegate = builder;
        return builder;
    }

    public SoapServerActionBuilder withReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
        return this;
    }

    public TestAction build() {
        Assert.notNull(this.delegate, (String)"Missing delegate action to build");
        return this.delegate.build();
    }

    public TestActionBuilder<?> getDelegate() {
        return this.delegate;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        if (referenceResolver == null) {
            this.referenceResolver = referenceResolver;
            if (this.delegate instanceof ReferenceResolverAware) {
                ((ReferenceResolverAware)this.delegate).setReferenceResolver(referenceResolver);
            }
        }
    }
}

