/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.citrusframework.endpoint.AbstractPollableEndpointConfiguration;
import org.citrusframework.endpoint.resolver.DynamicEndpointUriResolver;
import org.citrusframework.endpoint.resolver.EndpointUriResolver;
import org.citrusframework.message.DefaultMessageCorrelator;
import org.citrusframework.message.ErrorHandlingStrategy;
import org.citrusframework.message.MessageCorrelator;
import org.citrusframework.ws.interceptor.LoggingClientInterceptor;
import org.citrusframework.ws.message.converter.SoapMessageConverter;
import org.citrusframework.ws.message.converter.WebServiceMessageConverter;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.transport.WebServiceMessageSender;

public class WebServiceEndpointConfiguration
extends AbstractPollableEndpointConfiguration {
    private WebServiceTemplate webServiceTemplate;
    private WebServiceMessageFactory messageFactory;
    private WebServiceMessageSender messageSender;
    private WebServiceMessageConverter messageConverter = new SoapMessageConverter();
    private List<ClientInterceptor> interceptors;
    private String defaultUri;
    private MessageCorrelator correlator = new DefaultMessageCorrelator();
    private EndpointUriResolver endpointResolver = new DynamicEndpointUriResolver();
    private ErrorHandlingStrategy errorHandlingStrategy = ErrorHandlingStrategy.THROWS_EXCEPTION;
    private boolean handleMimeHeaders = true;
    private boolean handleAttributeHeaders = false;
    private boolean keepSoapEnvelope = false;

    public WebServiceEndpointConfiguration() {
        ArrayList<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
        interceptors.add(new LoggingClientInterceptor());
        this.setInterceptors(interceptors);
    }

    protected WebServiceTemplate createWebServiceTemplate() {
        return new WebServiceTemplate();
    }

    public void setCorrelator(MessageCorrelator correlator) {
        this.correlator = correlator;
    }

    public void setEndpointResolver(EndpointUriResolver endpointResolver) {
        this.endpointResolver = endpointResolver;
    }

    public ErrorHandlingStrategy getErrorHandlingStrategy() {
        return this.errorHandlingStrategy;
    }

    public void setErrorHandlingStrategy(ErrorHandlingStrategy errorHandlingStrategy) {
        this.errorHandlingStrategy = errorHandlingStrategy;
    }

    public MessageCorrelator getCorrelator() {
        return this.correlator;
    }

    public EndpointUriResolver getEndpointResolver() {
        return this.endpointResolver;
    }

    public WebServiceTemplate getWebServiceTemplate() {
        if (this.webServiceTemplate == null) {
            this.webServiceTemplate = this.createWebServiceTemplate();
        }
        if (this.messageFactory != null) {
            this.webServiceTemplate.setMessageFactory(this.messageFactory);
        }
        if (this.messageSender != null) {
            this.webServiceTemplate.setMessageSender(this.messageSender);
        }
        if (this.defaultUri != null) {
            this.webServiceTemplate.setDefaultUri(this.defaultUri);
        }
        return this.webServiceTemplate;
    }

    public void setWebServiceTemplate(WebServiceTemplate webServiceTemplate) {
        this.interceptors.addAll(Optional.ofNullable(webServiceTemplate.getInterceptors()).map(Arrays::asList).orElse(Collections.emptyList()));
        this.webServiceTemplate = webServiceTemplate;
        webServiceTemplate.setInterceptors(this.interceptors.toArray(new ClientInterceptor[0]));
    }

    public WebServiceMessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(WebServiceMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public WebServiceMessageSender getMessageSender() {
        return this.messageSender;
    }

    public void setMessageSender(WebServiceMessageSender messageSender) {
        this.messageSender = messageSender;
    }

    public String getDefaultUri() {
        return this.defaultUri;
    }

    public void setDefaultUri(String defaultUri) {
        this.defaultUri = defaultUri;
    }

    public List<ClientInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<ClientInterceptor> interceptors) {
        this.interceptors = interceptors;
        this.getWebServiceTemplate().setInterceptors(interceptors.toArray(new ClientInterceptor[0]));
    }

    public void setInterceptor(ClientInterceptor interceptor) {
        ArrayList<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
        interceptors.add(interceptor);
        this.setInterceptors(interceptors);
    }

    public WebServiceMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(WebServiceMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public boolean isHandleMimeHeaders() {
        return this.handleMimeHeaders;
    }

    public void setHandleMimeHeaders(boolean handleMimeHeaders) {
        this.handleMimeHeaders = handleMimeHeaders;
    }

    public boolean isKeepSoapEnvelope() {
        return this.keepSoapEnvelope;
    }

    public void setKeepSoapEnvelope(boolean keepSoapEnvelope) {
        this.keepSoapEnvelope = keepSoapEnvelope;
    }

    public boolean isHandleAttributeHeaders() {
        return this.handleAttributeHeaders;
    }

    public void setHandleAttributeHeaders(boolean handleAttributeHeaders) {
        this.handleAttributeHeaders = handleAttributeHeaders;
    }
}

