/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.config.annotation;

import org.citrusframework.TestActor;
import org.citrusframework.config.annotation.AnnotationConfigParser;
import org.citrusframework.endpoint.EndpointAdapter;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.ws.config.annotation.WebServiceServerConfig;
import org.citrusframework.ws.message.converter.WebServiceMessageConverter;
import org.citrusframework.ws.server.WebServiceServer;
import org.citrusframework.ws.server.WebServiceServerBuilder;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.servlet.ServletHandler;
import org.springframework.util.StringUtils;
import org.springframework.ws.server.EndpointInterceptor;

public class WebServiceServerConfigParser
implements AnnotationConfigParser<WebServiceServerConfig, WebServiceServer> {
    public WebServiceServer parse(WebServiceServerConfig annotation, ReferenceResolver referenceResolver) {
        WebServiceServerBuilder builder = new WebServiceServerBuilder();
        builder.handleMimeHeaders(annotation.handleMimeHeaders());
        builder.handleAttributeHeaders(annotation.handleAttributeHeaders());
        builder.keepSoapEnvelope(annotation.keepSoapEnvelope());
        if (StringUtils.hasText((String)annotation.soapHeaderNamespace())) {
            builder.soapHeaderNamespace(annotation.soapHeaderNamespace());
        }
        if (StringUtils.hasText((String)annotation.soapHeaderPrefix())) {
            builder.soapHeaderPrefix(annotation.soapHeaderPrefix());
        }
        if (StringUtils.hasText((String)annotation.messageFactory())) {
            builder.messageFactory(annotation.messageFactory());
        }
        builder.timeout(annotation.timeout());
        builder.port(annotation.port());
        builder.autoStart(annotation.autoStart());
        if (StringUtils.hasText((String)annotation.resourceBase())) {
            builder.resourceBase(annotation.resourceBase());
        }
        if (StringUtils.hasText((String)annotation.contextConfigLocation())) {
            builder.contextConfigLocation(annotation.contextConfigLocation());
        }
        builder.connectors(referenceResolver.resolve(annotation.connectors(), Connector.class));
        if (StringUtils.hasText((String)annotation.connector())) {
            builder.connector((Connector)referenceResolver.resolve(annotation.connector(), Connector.class));
        }
        builder.rootParentContext(annotation.rootParentContext());
        if (StringUtils.hasText((String)annotation.servletName())) {
            builder.servletName(annotation.servletName());
        }
        if (StringUtils.hasText((String)annotation.servletMappingPath())) {
            builder.servletMappingPath(annotation.servletMappingPath());
        }
        if (StringUtils.hasText((String)annotation.contextPath())) {
            builder.contextPath(annotation.contextPath());
        }
        if (StringUtils.hasText((String)annotation.servletHandler())) {
            builder.servletHandler((ServletHandler)referenceResolver.resolve(annotation.servletHandler(), ServletHandler.class));
        }
        if (StringUtils.hasText((String)annotation.securityHandler())) {
            builder.securityHandler((SecurityHandler)referenceResolver.resolve(annotation.securityHandler(), SecurityHandler.class));
        }
        builder.debugLogging(annotation.debugLogging());
        if (StringUtils.hasText((String)annotation.endpointAdapter())) {
            builder.endpointAdapter((EndpointAdapter)referenceResolver.resolve(annotation.endpointAdapter(), EndpointAdapter.class));
        }
        builder.interceptors(referenceResolver.resolve(annotation.interceptors(), EndpointInterceptor.class));
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((WebServiceMessageConverter)referenceResolver.resolve(annotation.messageConverter(), WebServiceMessageConverter.class));
        }
        return (WebServiceServer)builder.initialize().build();
    }
}

