/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.config.xml;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.citrusframework.config.xml.AbstractSendMessageActionFactoryBean;
import org.citrusframework.ws.actions.SendSoapFaultAction;
import org.citrusframework.ws.config.xml.SendSoapMessageActionParser;
import org.citrusframework.ws.message.SoapAttachment;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SendSoapFaultActionParser
extends SendSoapMessageActionParser {
    @Override
    public BeanDefinitionBuilder parseComponent(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = super.parseComponent(element, parserContext);
        this.parseFault(builder, DomUtils.getChildElementByTagName((Element)element, (String)"fault"));
        return builder;
    }

    private void parseFault(BeanDefinitionBuilder builder, Element faultElement) {
        if (faultElement != null) {
            Element faultActorElement;
            Element faultStringElement;
            Element faultCodeElement = DomUtils.getChildElementByTagName((Element)faultElement, (String)"fault-code");
            if (faultCodeElement != null) {
                builder.addPropertyValue("faultCode", (Object)DomUtils.getTextValue((Element)faultCodeElement).trim());
            }
            if ((faultStringElement = DomUtils.getChildElementByTagName((Element)faultElement, (String)"fault-string")) != null) {
                builder.addPropertyValue("faultString", (Object)DomUtils.getTextValue((Element)faultStringElement).trim());
            }
            if ((faultActorElement = DomUtils.getChildElementByTagName((Element)faultElement, (String)"fault-actor")) != null) {
                builder.addPropertyValue("faultActor", (Object)DomUtils.getTextValue((Element)faultActorElement).trim());
            }
            this.parseFaultDetail(builder, faultElement);
        }
    }

    private void parseFaultDetail(BeanDefinitionBuilder builder, Element faultElement) {
        List faultDetailElements = DomUtils.getChildElementsByTagName((Element)faultElement, (String)"fault-detail");
        ArrayList<String> faultDetails = new ArrayList<String>();
        ArrayList<CallSite> faultDetailResourcePaths = new ArrayList<CallSite>();
        for (Element faultDetailElement : faultDetailElements) {
            if (faultDetailElement.hasAttribute("file")) {
                if (StringUtils.hasText((String)DomUtils.getTextValue((Element)faultDetailElement).trim())) {
                    throw new BeanCreationException("You tried to set fault-detail by file resource attribute and inline text value at the same time! Please choose one of them.");
                }
                String charset = faultDetailElement.getAttribute("charset");
                String filePath = faultDetailElement.getAttribute("file");
                faultDetailResourcePaths.add((CallSite)((Object)(filePath + (String)(StringUtils.hasText((String)charset) ? ";charset=" + charset : ""))));
                continue;
            }
            String faultDetailData = DomUtils.getTextValue((Element)faultDetailElement).trim();
            if (StringUtils.hasText((String)faultDetailData)) {
                faultDetails.add(faultDetailData);
                continue;
            }
            throw new BeanCreationException("Not content for fault-detail is set! Either use file attribute or inline text value for fault-detail element.");
        }
        builder.addPropertyValue("faultDetails", faultDetails);
        builder.addPropertyValue("faultDetailResourcePaths", faultDetailResourcePaths);
    }

    protected Class<SendSoapFaultActionFactoryBean> getBeanDefinitionClass() {
        return SendSoapFaultActionFactoryBean.class;
    }

    public static class SendSoapFaultActionFactoryBean
    extends AbstractSendMessageActionFactoryBean<SendSoapFaultAction, SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport, SendSoapFaultAction.Builder> {
        private final SendSoapFaultAction.Builder builder = new SendSoapFaultAction.Builder();

        public void setAttachments(List<SoapAttachment> attachments) {
            attachments.forEach(((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)this.builder.message())::attachment);
        }

        public void setMtomEnabled(boolean mtomEnabled) {
            ((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)this.builder.message()).mtomEnabled(mtomEnabled);
        }

        public void setFaultCode(String faultCode) {
            ((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)this.builder.message()).faultCode(faultCode);
        }

        public void setFaultString(String faultString) {
            ((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)this.builder.message()).faultString(faultString);
        }

        public void setFaultActor(String faultActor) {
            ((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)this.builder.message()).faultActor(faultActor);
        }

        public void setFaultDetails(List<String> faultDetails) {
            faultDetails.forEach(((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)this.builder.message())::faultDetail);
        }

        public void setFaultDetailResourcePaths(List<String> faultDetailResourcePaths) {
            faultDetailResourcePaths.forEach(((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)this.builder.message())::faultDetailResource);
        }

        public SendSoapFaultAction getObject() throws Exception {
            return (SendSoapFaultAction)this.builder.build();
        }

        public Class<?> getObjectType() {
            return SendSoapFaultAction.class;
        }

        public SendSoapFaultAction.Builder getBuilder() {
            return this.builder;
        }
    }
}

