/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.config.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.citrusframework.config.xml.AbstractSendMessageActionFactoryBean;
import org.citrusframework.config.xml.SendMessageActionParser;
import org.citrusframework.message.MessageHeaderBuilder;
import org.citrusframework.message.builder.DefaultHeaderBuilder;
import org.citrusframework.validation.builder.DefaultMessageBuilder;
import org.citrusframework.validation.context.ValidationContext;
import org.citrusframework.ws.actions.SendSoapMessageAction;
import org.citrusframework.ws.config.xml.SoapAttachmentParser;
import org.citrusframework.ws.message.SoapAttachment;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SendSoapMessageActionParser
extends SendMessageActionParser {
    public BeanDefinitionBuilder parseComponent(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = super.parseComponent(element, parserContext);
        List attachmentElements = DomUtils.getChildElementsByTagName((Element)element, (String)"attachment");
        ArrayList<SoapAttachment> attachments = new ArrayList<SoapAttachment>();
        for (Element attachment : attachmentElements) {
            attachments.add(SoapAttachmentParser.parseAttachment(attachment));
        }
        builder.addPropertyValue("attachments", attachments);
        if (element.hasAttribute("mtom-enabled")) {
            builder.addPropertyValue("mtomEnabled", (Object)element.getAttribute("mtom-enabled"));
        }
        return builder;
    }

    protected void parseHeaderElements(Element actionElement, DefaultMessageBuilder messageBuilder, List<ValidationContext> validationContexts) {
        super.parseHeaderElements(actionElement, messageBuilder, validationContexts);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (actionElement.hasAttribute("soap-action")) {
            headers.put("citrus_soap_action", actionElement.getAttribute("soap-action"));
        }
        if (actionElement.hasAttribute("content-type")) {
            headers.put("citrus_http_Content-Type", actionElement.getAttribute("content-type"));
        }
        if (actionElement.hasAttribute("accept")) {
            headers.put("citrus_http_Accept", actionElement.getAttribute("accept"));
        }
        if (!headers.isEmpty()) {
            messageBuilder.addHeaderBuilder((MessageHeaderBuilder)new DefaultHeaderBuilder(headers));
        }
    }

    protected Class<? extends AbstractSendMessageActionFactoryBean<?, ?, ?>> getBeanDefinitionClass() {
        return SendSoapMessageActionFactoryBean.class;
    }

    public static class SendSoapMessageActionFactoryBean
    extends AbstractSendMessageActionFactoryBean<SendSoapMessageAction, SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport, SendSoapMessageAction.Builder> {
        private final SendSoapMessageAction.Builder builder = new SendSoapMessageAction.Builder();

        public void setAttachments(List<SoapAttachment> attachments) {
            attachments.forEach(((SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport)this.builder.message())::attachment);
        }

        public void setMtomEnabled(boolean mtomEnabled) {
            ((SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport)this.builder.message()).mtomEnabled(mtomEnabled);
        }

        public SendSoapMessageAction getObject() throws Exception {
            return (SendSoapMessageAction)this.builder.build();
        }

        public Class<?> getObjectType() {
            return SendSoapMessageAction.class;
        }

        public SendSoapMessageAction.Builder getBuilder() {
            return this.builder;
        }
    }
}

