/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.validation;

import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.util.XMLUtils;
import org.citrusframework.ws.message.SoapFault;
import org.citrusframework.ws.validation.AbstractSoapFaultValidator;
import org.citrusframework.ws.validation.SoapFaultDetailValidationContext;
import org.citrusframework.ws.validation.SoapFaultValidationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractFaultDetailValidator
extends AbstractSoapFaultValidator {
    private static Logger log = LoggerFactory.getLogger(AbstractFaultDetailValidator.class);

    @Override
    protected void validateFaultDetail(SoapFault receivedDetail, SoapFault controlDetail, TestContext context, SoapFaultValidationContext validationContext) {
        if (controlDetail == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Validating SOAP fault detail content ...");
        }
        if (receivedDetail == null) {
            throw new ValidationException("Missing SOAP fault detail in received message");
        }
        List<String> receivedDetailElements = receivedDetail.getFaultDetails();
        List<String> controlDetailElements = controlDetail.getFaultDetails();
        if (controlDetailElements.size() > receivedDetailElements.size()) {
            throw new ValidationException("Missing SOAP fault detail entry in received message");
        }
        for (int i = 0; i < controlDetailElements.size(); ++i) {
            String receivedDetailString = receivedDetailElements.get(i);
            String controlDetailString = controlDetailElements.get(i);
            SoapFaultDetailValidationContext detailValidationContext = CollectionUtils.isEmpty(validationContext.getValidationContexts()) ? new SoapFaultDetailValidationContext.Builder().build() : validationContext.getValidationContexts().get(i++);
            this.validateFaultDetailString(XMLUtils.omitXmlDeclaration((String)receivedDetailString), XMLUtils.omitXmlDeclaration((String)controlDetailString), context, detailValidationContext);
        }
    }

    protected abstract void validateFaultDetailString(String var1, String var2, TestContext var3, SoapFaultDetailValidationContext var4) throws ValidationException;
}

