/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.validation;

import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.validation.matcher.ValidationMatcherUtils;
import org.citrusframework.ws.message.SoapFault;
import org.citrusframework.ws.validation.SoapFaultValidationContext;
import org.citrusframework.ws.validation.SoapFaultValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractSoapFaultValidator
implements SoapFaultValidator {
    private static Logger log = LoggerFactory.getLogger(AbstractSoapFaultValidator.class);

    @Override
    public void validateSoapFault(SoapFault receivedFault, SoapFault controlFault, TestContext context, SoapFaultValidationContext validationContext) throws ValidationException {
        if (controlFault.getFaultString() != null && !controlFault.getFaultString().equals(receivedFault.getFaultString())) {
            if (controlFault.getFaultString().equals("@ignore@")) {
                log.debug("SOAP fault-string is ignored by placeholder - skipped fault-string validation");
            } else if (ValidationMatcherUtils.isValidationMatcherExpression((String)controlFault.getFaultString())) {
                ValidationMatcherUtils.resolveValidationMatcher((String)"SOAP fault string", (String)receivedFault.getFaultString(), (String)controlFault.getFaultString(), (TestContext)context);
            } else {
                throw new ValidationException("SOAP fault validation failed! Fault string does not match - expected: '" + controlFault.getFaultString() + "' but was: '" + receivedFault.getFaultString() + "'");
            }
        }
        if (StringUtils.hasText((String)controlFault.getFaultCodeQName().getLocalPart())) {
            Assert.isTrue((boolean)controlFault.getFaultCodeQName().equals(receivedFault.getFaultCodeQName()), (String)("SOAP fault validation failed! Fault code does not match - expected: '" + controlFault.getFaultCodeQName() + "' but was: '" + receivedFault.getFaultCodeQName() + "'"));
        }
        if (StringUtils.hasText((String)controlFault.getFaultActor())) {
            if (controlFault.getFaultActor().startsWith("@") && controlFault.getFaultActor().endsWith("@")) {
                ValidationMatcherUtils.resolveValidationMatcher((String)"SOAP fault actor", (String)receivedFault.getFaultActor(), (String)controlFault.getFaultActor(), (TestContext)context);
            } else {
                Assert.isTrue((boolean)controlFault.getFaultActor().equals(receivedFault.getFaultActor()), (String)("SOAP fault validation failed! Fault actor does not match - expected: '" + controlFault.getFaultActor() + "' but was: '" + receivedFault.getFaultActor() + "'"));
            }
        }
        if (!CollectionUtils.isEmpty(controlFault.getFaultDetails())) {
            this.validateFaultDetail(receivedFault, controlFault, context, validationContext);
        }
    }

    protected abstract void validateFaultDetail(SoapFault var1, SoapFault var2, TestContext var3, SoapFaultValidationContext var4);
}

