/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.validation;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.ws.message.SoapAttachment;
import org.citrusframework.ws.validation.AbstractSoapAttachmentValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class BinarySoapAttachmentValidator
extends AbstractSoapAttachmentValidator {
    private static Logger log = LoggerFactory.getLogger(BinarySoapAttachmentValidator.class);

    @Override
    protected void validateAttachmentContent(SoapAttachment receivedAttachment, SoapAttachment controlAttachment) {
        if (log.isDebugEnabled()) {
            log.debug("Validating binary SOAP attachment content ...");
        }
        try {
            Assert.isTrue((boolean)IOUtils.contentEquals((InputStream)receivedAttachment.getInputStream(), (InputStream)controlAttachment.getInputStream()), (String)("Values not equal for binary attachment content '" + Optional.ofNullable(controlAttachment.getContentId()).orElse(Optional.ofNullable(receivedAttachment.getContentId()).orElse("unknown")) + "'"));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Binary SOAP attachment validation failed", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Validating binary SOAP attachment content: OK");
        }
    }
}

