/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.validation;

import org.citrusframework.ws.message.SoapAttachment;
import org.citrusframework.ws.validation.AbstractSoapAttachmentValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SimpleSoapAttachmentValidator
extends AbstractSoapAttachmentValidator {
    private boolean ignoreAllWhitespaces = false;
    private static Logger log = LoggerFactory.getLogger(SimpleSoapAttachmentValidator.class);

    @Override
    protected void validateAttachmentContent(SoapAttachment receivedAttachment, SoapAttachment controlAttachment) {
        String receivedContent = StringUtils.trimWhitespace((String)receivedAttachment.getContent());
        String controlContent = StringUtils.trimWhitespace((String)controlAttachment.getContent());
        if (log.isDebugEnabled()) {
            log.debug("Validating SOAP attachment content ...");
            log.debug("Received attachment content: " + receivedContent);
            log.debug("Control attachment content: " + controlContent);
        }
        if (receivedContent != null) {
            Assert.isTrue((controlContent != null ? 1 : 0) != 0, (String)("Values not equal for attachment content '" + controlAttachment.getContentId() + "', expected 'null' but was '" + receivedContent + "'"));
            this.validateAttachmentContentData(receivedContent, controlContent, controlAttachment.getContentId());
        } else {
            Assert.isTrue((!StringUtils.hasLength((String)controlContent) ? 1 : 0) != 0, (String)("Values not equal for attachment content '" + controlAttachment.getContentId() + "', expected '" + controlContent + "' but was 'null'"));
        }
        if (log.isDebugEnabled()) {
            log.debug("Validating attachment content: OK");
        }
    }

    protected void validateAttachmentContentData(String receivedContent, String controlContent, String controlContentId) {
        if (this.ignoreAllWhitespaces) {
            controlContent = StringUtils.trimAllWhitespace((String)controlContent);
            receivedContent = StringUtils.trimAllWhitespace((String)receivedContent);
        }
        Assert.isTrue((boolean)receivedContent.equals(controlContent), (String)("Values not equal for attachment content '" + controlContentId + "', expected '" + controlContent.trim() + "' but was '" + receivedContent.trim() + "'"));
    }

    public boolean isIgnoreAllWhitespaces() {
        return this.ignoreAllWhitespaces;
    }

    public void setIgnoreAllWhitespaces(boolean ignoreAllWhitespaces) {
        this.ignoreAllWhitespaces = ignoreAllWhitespaces;
    }
}

