/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.validation;

import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.ws.validation.AbstractFaultDetailValidator;
import org.citrusframework.ws.validation.SoapFaultDetailValidationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SimpleSoapFaultValidator
extends AbstractFaultDetailValidator {
    private static Logger log = LoggerFactory.getLogger(SimpleSoapFaultValidator.class);

    @Override
    protected void validateFaultDetailString(String received, String control, TestContext context, SoapFaultDetailValidationContext validationContext) throws ValidationException {
        log.debug("Validating SOAP fault detail ...");
        String receivedDetail = StringUtils.trimAllWhitespace((String)received);
        String controlDetail = StringUtils.trimAllWhitespace((String)control);
        if (log.isDebugEnabled()) {
            log.debug("Received fault detail:\n" + StringUtils.trimWhitespace((String)received));
            log.debug("Control fault detail:\n" + StringUtils.trimWhitespace((String)control));
        }
        if (!receivedDetail.equals(controlDetail)) {
            throw new ValidationException("SOAP fault validation failed! Fault detail does not match: expected \n'" + controlDetail + "' \n received \n'" + receivedDetail + "'");
        }
        log.info("SOAP fault detail validation successful: All values OK");
    }
}

