/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.validation;

import java.util.Collections;
import java.util.Optional;
import org.citrusframework.context.TestContextFactory;
import org.citrusframework.context.TestContextFactoryBean;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.DefaultMessage;
import org.citrusframework.message.Message;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.validation.MessageValidator;
import org.citrusframework.validation.context.ValidationContext;
import org.citrusframework.validation.xml.XmlMessageValidationContext;
import org.citrusframework.ws.validation.SimpleSoapAttachmentValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlSoapAttachmentValidator
extends SimpleSoapAttachmentValidator
implements ReferenceResolverAware {
    private static final Logger LOG = LoggerFactory.getLogger(XmlSoapAttachmentValidator.class);
    private TestContextFactory testContextFactory;
    private MessageValidator<? extends ValidationContext> messageValidator;
    private ReferenceResolver referenceResolver;
    public static final String DEFAULT_XML_MESSAGE_VALIDATOR = "defaultXmlMessageValidator";

    @Override
    protected void validateAttachmentContentData(String receivedContent, String controlContent, String controlContentId) {
        this.getMessageValidator().validateMessage((Message)new DefaultMessage((Object)receivedContent), (Message)new DefaultMessage((Object)controlContent), this.getTestContextFactory().getObject(), Collections.singletonList(new XmlMessageValidationContext()));
    }

    private TestContextFactory getTestContextFactory() {
        if (this.testContextFactory == null) {
            this.testContextFactory = this.referenceResolver != null && this.referenceResolver.isResolvable(TestContextFactoryBean.class) ? (TestContextFactory)this.referenceResolver.resolve(TestContextFactoryBean.class) : TestContextFactory.newInstance();
        }
        return this.testContextFactory;
    }

    private MessageValidator<? extends ValidationContext> getMessageValidator() {
        if (this.messageValidator != null) {
            return this.messageValidator;
        }
        Optional<MessageValidator> defaultMessageValidator = this.getTestContextFactory().getMessageValidatorRegistry().findMessageValidator(DEFAULT_XML_MESSAGE_VALIDATOR);
        if (defaultMessageValidator.isEmpty()) {
            try {
                defaultMessageValidator = Optional.of((MessageValidator)this.getTestContextFactory().getReferenceResolver().resolve(DEFAULT_XML_MESSAGE_VALIDATOR, MessageValidator.class));
            }
            catch (CitrusRuntimeException e) {
                LOG.warn("Unable to find default XML message validator in message validator registry");
            }
        }
        if (defaultMessageValidator.isEmpty()) {
            defaultMessageValidator = MessageValidator.lookup((String)"xml");
        }
        if (defaultMessageValidator.isPresent()) {
            this.messageValidator = (MessageValidator)defaultMessageValidator.get();
            return this.messageValidator;
        }
        throw new CitrusRuntimeException("Unable to locate proper XML message validator - please add validator to project");
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }
}

