/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.validation;

import java.util.Collections;
import java.util.Optional;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.message.DefaultMessage;
import org.citrusframework.message.Message;
import org.citrusframework.validation.MessageValidator;
import org.citrusframework.validation.context.ValidationContext;
import org.citrusframework.ws.validation.AbstractFaultDetailValidator;
import org.citrusframework.ws.validation.SoapFaultDetailValidationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlSoapFaultValidator
extends AbstractFaultDetailValidator {
    private static Logger log = LoggerFactory.getLogger(XmlSoapFaultValidator.class);
    private MessageValidator<? extends ValidationContext> messageValidator;
    public static final String DEFAULT_XML_MESSAGE_VALIDATOR = "defaultXmlMessageValidator";

    @Override
    protected void validateFaultDetailString(String receivedDetailString, String controlDetailString, TestContext context, SoapFaultDetailValidationContext validationContext) throws ValidationException {
        this.getMessageValidator(context).validateMessage((Message)new DefaultMessage((Object)receivedDetailString), (Message)new DefaultMessage((Object)controlDetailString), context, Collections.singletonList(validationContext));
    }

    private MessageValidator<? extends ValidationContext> getMessageValidator(TestContext context) {
        if (this.messageValidator != null) {
            return this.messageValidator;
        }
        Optional<MessageValidator> defaultMessageValidator = context.getMessageValidatorRegistry().findMessageValidator(DEFAULT_XML_MESSAGE_VALIDATOR);
        if (!defaultMessageValidator.isPresent()) {
            try {
                defaultMessageValidator = Optional.of((MessageValidator)context.getReferenceResolver().resolve(DEFAULT_XML_MESSAGE_VALIDATOR, MessageValidator.class));
            }
            catch (CitrusRuntimeException e) {
                log.warn("Unable to find default XML message validator in message validator registry");
            }
        }
        if (!defaultMessageValidator.isPresent()) {
            defaultMessageValidator = MessageValidator.lookup((String)"xml");
        }
        if (defaultMessageValidator.isPresent()) {
            this.messageValidator = defaultMessageValidator.get();
            return this.messageValidator;
        }
        throw new CitrusRuntimeException("Unable to locate proper JSON message validator - please add validator to project");
    }
}

