/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.actions;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.citrusframework.TestAction;
import org.citrusframework.actions.SendMessageAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageBuilder;
import org.citrusframework.message.builder.SendMessageBuilderSupport;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.validation.builder.StaticMessageBuilder;
import org.citrusframework.ws.message.SoapAttachment;
import org.citrusframework.ws.message.SoapMessage;
import org.citrusframework.ws.message.SoapMessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendSoapMessageAction
extends SendMessageAction
implements TestAction {
    private static final Logger logger = LoggerFactory.getLogger(SendSoapMessageAction.class);
    private final List<SoapAttachment> attachments;
    private final boolean mtomEnabled;
    public static final String CID_MARKER = "cid:";

    public SendSoapMessageAction(SendSoapMessageBuilder<?, ?, ?> builder) {
        super(builder);
        this.attachments = ((SoapMessageBuilderSupport)builder.getMessageBuilderSupport()).getAttachments();
        this.mtomEnabled = ((SoapMessageBuilderSupport)builder.getMessageBuilderSupport()).isMtomEnabled();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected SoapMessage createMessage(TestContext context, String messageType) {
        Message message = super.createMessage(context, this.getMessageType());
        SoapMessage soapMessage = new SoapMessage(message).mtomEnabled(this.mtomEnabled);
        try {
            for (SoapAttachment attachment : this.attachments) {
                attachment.setTestContext(context);
                if (this.mtomEnabled) {
                    String messagePayload = (String)soapMessage.getPayload(String.class);
                    String cid = CID_MARKER + attachment.getContentId();
                    if (attachment.isMtomInline() && messagePayload.contains(cid)) {
                        byte[] attachmentBinaryData = FileUtils.readToString((InputStream)attachment.getInputStream(), (Charset)Charset.forName(attachment.getCharsetName())).getBytes(Charset.forName(attachment.getCharsetName()));
                        if (attachment.getEncodingType().equals("base64Binary")) {
                            if (logger.isDebugEnabled()) {
                                logger.debug(String.format("Adding inline base64Binary data for attachment: %s", cid));
                            }
                            messagePayload = messagePayload.replaceAll(cid, Base64.encodeBase64String((byte[])attachmentBinaryData));
                        } else {
                            if (!attachment.getEncodingType().equals("hexBinary")) throw new CitrusRuntimeException(String.format("Unsupported encoding type '%s' for SOAP attachment: %s - choose one of %s or %s", attachment.getEncodingType(), cid, "base64Binary", "hexBinary"));
                            if (logger.isDebugEnabled()) {
                                logger.debug(String.format("Adding inline hexBinary data for attachment: %s", cid));
                            }
                            messagePayload = messagePayload.replaceAll(cid, Hex.encodeHexString((byte[])attachmentBinaryData).toUpperCase());
                        }
                    } else {
                        messagePayload = messagePayload.replaceAll(cid, String.format("<xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"%s\"/>", CID_MARKER + URLEncoder.encode(attachment.getContentId(), "UTF-8")));
                        soapMessage.addAttachment(attachment);
                    }
                    soapMessage.setPayload(messagePayload);
                    continue;
                }
                soapMessage.addAttachment(attachment);
            }
            return soapMessage;
        }
        catch (IOException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
    }

    public List<SoapAttachment> getAttachments() {
        return this.attachments;
    }

    public boolean getMtomEnabled() {
        return this.mtomEnabled;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public static abstract class SendSoapMessageBuilder<T extends SendSoapMessageAction, M extends SoapMessageBuilderSupport<T, B, M>, B extends SendSoapMessageBuilder<T, M, B>>
    extends SendMessageAction.SendMessageActionBuilder<T, M, B> {
        protected SoapMessage soapMessage = new SoapMessage();

        public B mtomEnabled(boolean mtomEnabled) {
            ((SoapMessageBuilderSupport)this.getMessageBuilderSupport()).mtomEnabled(mtomEnabled);
            return (B)((Object)((SendSoapMessageBuilder)this.self));
        }
    }

    public static class SoapMessageBuilderSupport<T extends SendSoapMessageAction, B extends SendSoapMessageBuilder<T, M, B>, M extends SoapMessageBuilderSupport<T, B, M>>
    extends SendMessageBuilderSupport<T, B, M> {
        protected final SoapMessage soapMessage;
        private final List<SoapAttachment> attachments = new ArrayList<SoapAttachment>();
        private boolean mtomEnabled = false;

        protected SoapMessageBuilderSupport(SoapMessage soapMessage, B delegate) {
            super(delegate);
            this.soapMessage = soapMessage;
        }

        public M body(String payload) {
            this.soapMessage.setPayload(payload);
            return (M)((Object)((SoapMessageBuilderSupport)this.self));
        }

        public M name(String name) {
            this.soapMessage.setName(name);
            return (M)((Object)((SoapMessageBuilderSupport)super.name(name)));
        }

        public M from(Message controlMessage) {
            SoapMessageUtils.copy(controlMessage, this.soapMessage);
            this.type(controlMessage.getType());
            return (M)((Object)((SoapMessageBuilderSupport)this.self));
        }

        public M soapAction(String soapAction) {
            this.soapMessage.header("citrus_soap_action", soapAction);
            return (M)((Object)((SoapMessageBuilderSupport)this.self));
        }

        public M attachment(String contentId, String contentType, String content) {
            SoapAttachment attachment = new SoapAttachment();
            attachment.setContentId(contentId);
            attachment.setContentType(contentType);
            attachment.setContent(content);
            this.attachment(attachment);
            return (M)((Object)((SoapMessageBuilderSupport)this.self));
        }

        public M attachment(String contentId, String contentType, Resource contentResource) {
            return this.attachment(contentId, contentType, contentResource, FileUtils.getDefaultCharset());
        }

        public M attachment(String contentId, String contentType, Resource contentResource, Charset charset) {
            SoapAttachment attachment = new SoapAttachment();
            attachment.setContentId(contentId);
            attachment.setContentType(contentType);
            try {
                attachment.setContent(FileUtils.readToString((Resource)contentResource, (Charset)charset));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read attachment resource", (Throwable)e);
            }
            this.attachment(attachment);
            return (M)((Object)((SoapMessageBuilderSupport)this.self));
        }

        public M charset(String charsetName) {
            if (!this.attachments.isEmpty()) {
                this.attachments.get(this.attachments.size() - 1).setCharsetName(charsetName);
            }
            return (M)((Object)((SoapMessageBuilderSupport)this.self));
        }

        public M attachment(SoapAttachment attachment) {
            this.attachments.add(attachment);
            return (M)((Object)((SoapMessageBuilderSupport)this.self));
        }

        public M uri(String uri) {
            this.soapMessage.header("citrus_endpoint_uri", uri);
            return (M)((Object)((SoapMessageBuilderSupport)this.self));
        }

        public M contentType(String contentType) {
            this.soapMessage.contentType(contentType);
            return (M)((Object)((SoapMessageBuilderSupport)this.self));
        }

        public M accept(String accept) {
            this.soapMessage.accept(accept);
            return (M)((Object)((SoapMessageBuilderSupport)this.self));
        }

        public M mtomEnabled(boolean mtomEnabled) {
            this.soapMessage.mtomEnabled(mtomEnabled);
            this.mtomEnabled = mtomEnabled;
            return (M)((Object)((SoapMessageBuilderSupport)this.self));
        }

        protected List<SoapAttachment> getAttachments() {
            return this.attachments;
        }

        protected boolean isMtomEnabled() {
            return this.mtomEnabled;
        }
    }

    public static final class Builder
    extends SendSoapMessageBuilder<SendSoapMessageAction, SendSoapMessageBuilderSupport, Builder> {
        public Builder() {
            this.message((MessageBuilder)new StaticMessageBuilder((Message)this.soapMessage));
        }

        public SendSoapMessageBuilderSupport getMessageBuilderSupport() {
            if (this.messageBuilderSupport == null) {
                this.messageBuilderSupport = new SendSoapMessageBuilderSupport(this.soapMessage, this);
            }
            return (SendSoapMessageBuilderSupport)super.getMessageBuilderSupport();
        }

        public SendSoapMessageAction doBuild() {
            return new SendSoapMessageAction(this);
        }

        public static class SendSoapMessageBuilderSupport
        extends SoapMessageBuilderSupport<SendSoapMessageAction, Builder, SendSoapMessageBuilderSupport> {
            protected SendSoapMessageBuilderSupport(SoapMessage soapMessage, Builder delegate) {
                super(soapMessage, delegate);
            }
        }
    }
}

