/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.server;

import jakarta.servlet.Servlet;
import java.nio.file.Paths;
import java.util.Arrays;
import org.citrusframework.context.SpringBeanReferenceResolver;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.report.MessageListeners;
import org.citrusframework.server.AbstractServer;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.StringUtils;
import org.citrusframework.ws.context.ParentDelegatingWebApplicationContext;
import org.citrusframework.ws.interceptor.LoggingEndpointInterceptor;
import org.citrusframework.ws.message.converter.SoapMessageConverter;
import org.citrusframework.ws.message.converter.WebServiceMessageConverter;
import org.citrusframework.ws.servlet.CitrusMessageDispatcherServlet;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.ServletMapping;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.springframework.web.context.WebApplicationContext;

public class WebServiceServer
extends AbstractServer {
    private int port = 8080;
    private String resourceBase = "src/main/resources";
    private String contextConfigLocation = "classpath:org/citrusframework/ws/citrus-servlet-context.xml";
    private Server jettyServer;
    private boolean useRootContextAsParent = false;
    private static Object serverLock = new Object();
    private Connector connector;
    private Connector[] connectors;
    private String servletMappingPath = "/*";
    private String servletName;
    private String contextPath = "/";
    private SecurityHandler securityHandler;
    private ServletHandler servletHandler;
    private boolean handleMimeHeaders = false;
    private boolean handleAttributeHeaders = false;
    private boolean keepSoapEnvelope = false;
    private WebServiceMessageConverter messageConverter = new SoapMessageConverter();
    private String messageFactoryName = "messageFactory";
    private String soapHeaderNamespace;
    private String soapHeaderPrefix = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        if (this.jettyServer != null) {
            try {
                Object object = serverLock;
                synchronized (object) {
                    this.jettyServer.stop();
                }
            }
            catch (Exception e) {
                throw new CitrusRuntimeException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startup() {
        Object object = serverLock;
        synchronized (object) {
            ReferenceResolver referenceResolver;
            if (this.connectors != null && this.connectors.length > 0) {
                this.jettyServer = this.connectors[0].getServer();
                this.jettyServer.setConnectors(this.connectors);
            } else if (this.connector != null) {
                this.jettyServer = this.connector.getServer();
                this.jettyServer.addConnector(this.connector);
            } else {
                this.jettyServer = new Server(this.port);
            }
            Handler.Sequence handlers = new Handler.Sequence(new Handler[0]);
            ContextHandlerCollection contextCollection = new ContextHandlerCollection(new ContextHandler[0]);
            ServletContextHandler contextHandler = new ServletContextHandler();
            contextHandler.setContextPath(this.contextPath);
            contextHandler.setBaseResourceAsPath(Paths.get(this.resourceBase, new String[0]));
            if (this.useRootContextAsParent && (referenceResolver = this.getReferenceResolver()) instanceof SpringBeanReferenceResolver) {
                SpringBeanReferenceResolver springBeanReferenceResolver = (SpringBeanReferenceResolver)referenceResolver;
                contextHandler.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)new ParentDelegatingWebApplicationContext(springBeanReferenceResolver.getApplicationContext()));
            }
            if (this.servletHandler == null) {
                this.servletHandler = new ServletHandler();
                this.addDispatcherServlet();
            }
            contextHandler.setServletHandler(this.servletHandler);
            if (this.securityHandler != null) {
                contextHandler.setSecurityHandler(this.securityHandler);
            }
            this.configure(contextHandler);
            contextCollection.addHandler((Handler)contextHandler);
            handlers.addHandler((Handler)contextCollection);
            handlers.addHandler((Handler)new DefaultHandler());
            this.jettyServer.setHandler((Handler)handlers);
            try {
                this.jettyServer.start();
            }
            catch (Exception e) {
                throw new CitrusRuntimeException((Throwable)e);
            }
        }
    }

    protected void configure(ServletContextHandler contextHandler) {
    }

    public void initialize() {
        super.initialize();
        if (this.getReferenceResolver() != null && this.getReferenceResolver().resolveAll(MessageListeners.class).size() == 1) {
            MessageListeners messageListeners = (MessageListeners)this.getReferenceResolver().resolve(MessageListeners.class);
            this.getInterceptors().stream().filter(LoggingEndpointInterceptor.class::isInstance).map(LoggingEndpointInterceptor.class::cast).filter(interceptor -> !interceptor.hasMessageListeners()).forEach(interceptor -> interceptor.setMessageListener(messageListeners));
        }
    }

    private void addDispatcherServlet() {
        ServletHolder servletHolder = new ServletHolder((Servlet)new CitrusMessageDispatcherServlet(this));
        servletHolder.setName(this.getServletName());
        servletHolder.setInitParameter("contextConfigLocation", this.contextConfigLocation);
        this.servletHandler.addServlet(servletHolder);
        ServletMapping servletMapping = new ServletMapping();
        servletMapping.setServletName(this.getServletName());
        servletMapping.setPathSpec(this.servletMappingPath);
        this.servletHandler.addServletMapping(servletMapping);
    }

    public String getServletName() {
        if (StringUtils.hasText((String)this.servletName)) {
            return this.servletName;
        }
        return this.getName() + "-servlet";
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getResourceBase() {
        return this.resourceBase;
    }

    public void setResourceBase(String resourceBase) {
        this.resourceBase = resourceBase;
    }

    public String getContextConfigLocation() {
        return this.contextConfigLocation;
    }

    public void setContextConfigLocation(String contextConfigLocation) {
        this.contextConfigLocation = contextConfigLocation;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public Connector[] getConnectors() {
        if (this.connectors != null) {
            return Arrays.copyOf(this.connectors, this.connectors.length);
        }
        return new Connector[0];
    }

    public void setConnectors(Connector[] connectors) {
        this.connectors = Arrays.copyOf(connectors, connectors.length);
    }

    public String getServletMappingPath() {
        return this.servletMappingPath;
    }

    public void setServletMappingPath(String servletMappingPath) {
        this.servletMappingPath = servletMappingPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public SecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    public void setSecurityHandler(SecurityHandler securityHandler) {
        this.securityHandler = securityHandler;
    }

    public ServletHandler getServletHandler() {
        return this.servletHandler;
    }

    public void setServletHandler(ServletHandler servletHandler) {
        this.servletHandler = servletHandler;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public boolean isUseRootContextAsParent() {
        return this.useRootContextAsParent;
    }

    public void setUseRootContextAsParent(boolean useRootContextAsParent) {
        this.useRootContextAsParent = useRootContextAsParent;
    }

    public boolean isHandleMimeHeaders() {
        return this.handleMimeHeaders;
    }

    public void setHandleMimeHeaders(boolean handleMimeHeaders) {
        this.handleMimeHeaders = handleMimeHeaders;
    }

    public boolean isHandleAttributeHeaders() {
        return this.handleAttributeHeaders;
    }

    public void setHandleAttributeHeaders(boolean handleAttributeHeaders) {
        this.handleAttributeHeaders = handleAttributeHeaders;
    }

    public boolean isKeepSoapEnvelope() {
        return this.keepSoapEnvelope;
    }

    public void setKeepSoapEnvelope(boolean keepSoapEnvelope) {
        this.keepSoapEnvelope = keepSoapEnvelope;
    }

    public String getSoapHeaderNamespace() {
        return this.soapHeaderNamespace;
    }

    public void setSoapHeaderNamespace(String soapHeaderNamespace) {
        this.soapHeaderNamespace = soapHeaderNamespace;
    }

    public String getSoapHeaderPrefix() {
        return this.soapHeaderPrefix;
    }

    public void setSoapHeaderPrefix(String soapHeaderPrefix) {
        this.soapHeaderPrefix = soapHeaderPrefix;
    }

    public WebServiceMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(WebServiceMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public String getMessageFactoryName() {
        return this.messageFactoryName;
    }

    public void setMessageFactoryName(String messageFactoryName) {
        this.messageFactoryName = messageFactoryName;
    }
}

