/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.actions;

import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.util.ObjectHelper;
import org.citrusframework.ws.actions.AssertSoapFault;
import org.citrusframework.ws.actions.ReceiveSoapMessageAction;
import org.citrusframework.ws.actions.SendSoapMessageAction;

public class SoapClientActionBuilder
implements TestActionBuilder.DelegatingTestActionBuilder<TestAction>,
ReferenceResolverAware {
    private ReferenceResolver referenceResolver;
    private Endpoint soapClient;
    private String soapClientUri;
    private TestActionBuilder<?> delegate;

    public SoapClientActionBuilder(Endpoint soapClient) {
        this.soapClient = soapClient;
    }

    public SoapClientActionBuilder(String soapClientUri) {
        this.soapClientUri = soapClientUri;
    }

    public ReceiveSoapMessageAction.Builder receive() {
        ReceiveSoapMessageAction.Builder builder = new ReceiveSoapMessageAction.Builder();
        if (this.soapClient != null) {
            builder.endpoint(this.soapClient);
        } else {
            builder.endpoint(this.soapClientUri);
        }
        builder.name("soap:receive-response");
        builder.withReferenceResolver(this.referenceResolver);
        this.delegate = builder;
        return builder;
    }

    public AssertSoapFault.Builder assertFault() {
        AssertSoapFault.Builder builder = new AssertSoapFault.Builder();
        if (this.soapClient != null) {
            builder.endpoint(this.soapClient);
        } else {
            builder.endpoint(this.soapClientUri);
        }
        builder.name("soap:assert-fault");
        builder.withReferenceResolver(this.referenceResolver);
        this.delegate = builder;
        return builder;
    }

    public SendSoapMessageAction.Builder send() {
        SendSoapMessageAction.Builder builder = new SendSoapMessageAction.Builder();
        if (this.soapClient != null) {
            builder.endpoint(this.soapClient);
        } else {
            builder.endpoint(this.soapClientUri);
        }
        builder.name("soap:send-request");
        builder.withReferenceResolver(this.referenceResolver);
        this.delegate = builder;
        return builder;
    }

    public SoapClientActionBuilder withReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
        return this;
    }

    public TestAction build() {
        ObjectHelper.assertNotNull(this.delegate, (String)"Missing delegate action to build");
        return this.delegate.build();
    }

    public TestActionBuilder<?> getDelegate() {
        return this.delegate;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        if (referenceResolver == null) {
            this.referenceResolver = referenceResolver;
            if (this.delegate instanceof ReferenceResolverAware) {
                ((ReferenceResolverAware)this.delegate).setReferenceResolver(referenceResolver);
            }
        }
    }
}

