/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.config.annotation;

import java.util.ArrayList;
import org.citrusframework.TestActor;
import org.citrusframework.config.annotation.AnnotationConfigParser;
import org.citrusframework.endpoint.resolver.EndpointUriResolver;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.MessageCorrelator;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.StringUtils;
import org.citrusframework.ws.client.WebServiceClient;
import org.citrusframework.ws.client.WebServiceClientBuilder;
import org.citrusframework.ws.config.annotation.WebServiceClientConfig;
import org.citrusframework.ws.message.converter.WebServiceMessageConverter;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.transport.WebServiceMessageSender;

public class WebServiceClientConfigParser
implements AnnotationConfigParser<WebServiceClientConfig, WebServiceClient> {
    public WebServiceClient parse(WebServiceClientConfig annotation, ReferenceResolver referenceResolver) {
        WebServiceClientBuilder builder = new WebServiceClientBuilder();
        builder.defaultUri(annotation.requestUrl());
        if (StringUtils.hasText((String)annotation.webServiceTemplate()) && (StringUtils.hasText((String)annotation.messageFactory()) || StringUtils.hasText((String)annotation.messageSender()))) {
            throw new CitrusRuntimeException("When providing a 'web-service-template' reference, none of 'message-factory', 'message-sender' should be set");
        }
        if (!StringUtils.hasText((String)annotation.requestUrl()) && !StringUtils.hasText((String)annotation.endpointResolver())) {
            throw new CitrusRuntimeException("One of the properties 'request-url' or 'endpoint-resolver' is required!");
        }
        if (StringUtils.hasText((String)annotation.webServiceTemplate())) {
            builder.webServiceTemplate((WebServiceTemplate)referenceResolver.resolve(annotation.webServiceTemplate(), WebServiceTemplate.class));
        }
        if (StringUtils.hasText((String)annotation.messageFactory())) {
            builder.messageFactory((WebServiceMessageFactory)referenceResolver.resolve(annotation.messageFactory(), WebServiceMessageFactory.class));
        } else {
            builder.messageFactory((WebServiceMessageFactory)referenceResolver.resolve("messageFactory", WebServiceMessageFactory.class));
        }
        if (StringUtils.hasText((String)annotation.messageSender())) {
            builder.messageSender((WebServiceMessageSender)referenceResolver.resolve(annotation.messageSender(), WebServiceMessageSender.class));
        }
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((WebServiceMessageConverter)referenceResolver.resolve(annotation.messageConverter(), WebServiceMessageConverter.class));
        }
        if (annotation.interceptors().length > 0) {
            builder.interceptors(referenceResolver.resolve(annotation.interceptors(), ClientInterceptor.class));
        }
        if (StringUtils.hasText((String)annotation.interceptor())) {
            ArrayList<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
            interceptors.add((ClientInterceptor)referenceResolver.resolve(annotation.interceptor(), ClientInterceptor.class));
            builder.interceptors(interceptors);
        }
        if (StringUtils.hasText((String)annotation.correlator())) {
            builder.correlator((MessageCorrelator)referenceResolver.resolve(annotation.correlator(), MessageCorrelator.class));
        }
        if (StringUtils.hasText((String)annotation.endpointResolver())) {
            builder.endpointResolver((EndpointUriResolver)referenceResolver.resolve(annotation.endpointResolver(), EndpointUriResolver.class));
        }
        builder.faultStrategy(annotation.faultStrategy());
        builder.pollingInterval(annotation.pollingInterval());
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        return (WebServiceClient)builder.initialize().build();
    }
}

