/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.config.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.citrusframework.config.util.BeanDefinitionParserUtils;
import org.citrusframework.config.xml.AbstractReceiveMessageActionFactoryBean;
import org.citrusframework.config.xml.ReceiveMessageActionParser;
import org.citrusframework.message.MessageHeaderBuilder;
import org.citrusframework.message.builder.DefaultHeaderBuilder;
import org.citrusframework.validation.builder.DefaultMessageBuilder;
import org.citrusframework.validation.context.ValidationContext;
import org.citrusframework.ws.actions.ReceiveSoapMessageAction;
import org.citrusframework.ws.config.xml.SoapAttachmentParser;
import org.citrusframework.ws.message.SoapAttachment;
import org.citrusframework.ws.validation.SoapAttachmentValidator;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ReceiveSoapMessageActionParser
extends ReceiveMessageActionParser {
    protected BeanDefinitionBuilder parseComponent(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ReceiveSoapMessageActionFactoryBean.class);
        List attachmentElements = DomUtils.getChildElementsByTagName((Element)element, (String)"attachment");
        ArrayList<SoapAttachment> attachments = new ArrayList<SoapAttachment>();
        for (Element attachment : attachmentElements) {
            attachments.add(SoapAttachmentParser.parseAttachment(attachment));
        }
        builder.addPropertyValue("attachments", attachments);
        if (!attachments.isEmpty()) {
            BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)builder, (String)((Element)attachmentElements.get(0)).getAttribute("validator"), (String)"attachmentValidator", (String)"soapAttachmentValidator");
        }
        return builder;
    }

    protected void parseHeaderElements(Element actionElement, DefaultMessageBuilder messageBuilder, List<ValidationContext> validationContexts) {
        super.parseHeaderElements(actionElement, messageBuilder, validationContexts);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (actionElement.hasAttribute("soap-action")) {
            headers.put("citrus_soap_action", actionElement.getAttribute("soap-action"));
        }
        if (actionElement.hasAttribute("content-type")) {
            headers.put("citrus_http_Content-Type", actionElement.getAttribute("content-type"));
        }
        if (actionElement.hasAttribute("accept")) {
            headers.put("citrus_http_Accept", actionElement.getAttribute("accept"));
        }
        if (!headers.isEmpty()) {
            messageBuilder.addHeaderBuilder((MessageHeaderBuilder)new DefaultHeaderBuilder(headers));
        }
    }

    public static class ReceiveSoapMessageActionFactoryBean
    extends AbstractReceiveMessageActionFactoryBean<ReceiveSoapMessageAction, ReceiveSoapMessageAction.SoapMessageBuilderSupport, ReceiveSoapMessageAction.Builder> {
        private final ReceiveSoapMessageAction.Builder builder = new ReceiveSoapMessageAction.Builder();

        public void setAttachments(List<SoapAttachment> attachments) {
            attachments.forEach(((ReceiveSoapMessageAction.SoapMessageBuilderSupport)this.builder.message())::attachment);
        }

        public void setAttachmentValidator(SoapAttachmentValidator attachmentValidator) {
            ((ReceiveSoapMessageAction.SoapMessageBuilderSupport)this.builder.message()).attachmentValidator(attachmentValidator);
        }

        public ReceiveSoapMessageAction getObject() throws Exception {
            return (ReceiveSoapMessageAction)this.builder.build();
        }

        public Class<?> getObjectType() {
            return ReceiveSoapMessageAction.class;
        }

        public ReceiveSoapMessageAction.Builder getBuilder() {
            return this.builder;
        }
    }
}

