/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.interceptor;

import javax.xml.transform.TransformerException;
import org.citrusframework.ws.interceptor.LoggingInterceptorSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ws.client.WebServiceClientException;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.soap.SoapEnvelopeException;

public class LoggingClientInterceptor
extends LoggingInterceptorSupport
implements ClientInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(LoggingClientInterceptor.class);

    public boolean handleRequest(MessageContext messageContext) throws WebServiceClientException {
        try {
            this.logRequest("Sending SOAP request", messageContext, false);
        }
        catch (TransformerException | SoapEnvelopeException e) {
            logger.warn("Unable to write SOAP request to logger", e);
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) throws WebServiceClientException {
        try {
            this.logResponse("Received SOAP response", messageContext, true);
        }
        catch (TransformerException | SoapEnvelopeException e) {
            logger.warn("Unable to write SOAP response to logger", e);
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext) throws WebServiceClientException {
        try {
            this.logResponse("Received SOAP fault", messageContext, true);
        }
        catch (TransformerException | SoapEnvelopeException e) {
            logger.warn("Unable to write SOAP fault to logger", e);
        }
        return true;
    }

    public void afterCompletion(MessageContext messageContext, Exception ex) throws WebServiceClientException {
    }
}

