/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.client;

import java.util.List;
import org.citrusframework.endpoint.AbstractEndpointBuilder;
import org.citrusframework.endpoint.resolver.EndpointUriResolver;
import org.citrusframework.message.ErrorHandlingStrategy;
import org.citrusframework.message.MessageCorrelator;
import org.citrusframework.ws.client.WebServiceClient;
import org.citrusframework.ws.message.converter.WebServiceMessageConverter;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.transport.WebServiceMessageSender;

public class WebServiceClientBuilder
extends AbstractEndpointBuilder<WebServiceClient> {
    private WebServiceClient endpoint = new WebServiceClient();

    protected WebServiceClient getEndpoint() {
        return this.endpoint;
    }

    public WebServiceClientBuilder defaultUri(String uri) {
        this.endpoint.getEndpointConfiguration().setDefaultUri(uri);
        return this;
    }

    public WebServiceClientBuilder messageFactory(WebServiceMessageFactory messageFactory) {
        this.endpoint.getEndpointConfiguration().setMessageFactory(messageFactory);
        return this;
    }

    public WebServiceClientBuilder keepSoapEnvelope(boolean flag) {
        this.endpoint.getEndpointConfiguration().setKeepSoapEnvelope(flag);
        return this;
    }

    public WebServiceClientBuilder webServiceTemplate(WebServiceTemplate webServiceTemplate) {
        this.endpoint.getEndpointConfiguration().setWebServiceTemplate(webServiceTemplate);
        return this;
    }

    public WebServiceClientBuilder messageSender(WebServiceMessageSender messageSender) {
        this.endpoint.getEndpointConfiguration().setMessageSender(messageSender);
        return this;
    }

    public WebServiceClientBuilder messageConverter(WebServiceMessageConverter messageConverter) {
        this.endpoint.getEndpointConfiguration().setMessageConverter(messageConverter);
        return this;
    }

    public WebServiceClientBuilder interceptor(ClientInterceptor interceptor) {
        this.endpoint.getEndpointConfiguration().setInterceptor(interceptor);
        return this;
    }

    public WebServiceClientBuilder interceptors(List<ClientInterceptor> interceptors) {
        this.endpoint.getEndpointConfiguration().setInterceptors(interceptors);
        return this;
    }

    public WebServiceClientBuilder correlator(MessageCorrelator correlator) {
        this.endpoint.getEndpointConfiguration().setCorrelator(correlator);
        return this;
    }

    public WebServiceClientBuilder endpointResolver(EndpointUriResolver resolver) {
        this.endpoint.getEndpointConfiguration().setEndpointResolver(resolver);
        return this;
    }

    public WebServiceClientBuilder faultStrategy(ErrorHandlingStrategy faultStrategy) {
        this.endpoint.getEndpointConfiguration().setErrorHandlingStrategy(faultStrategy);
        return this;
    }

    public WebServiceClientBuilder pollingInterval(int pollingInterval) {
        this.endpoint.getEndpointConfiguration().setPollingInterval(pollingInterval);
        return this;
    }

    public WebServiceClientBuilder timeout(long timeout) {
        this.endpoint.getEndpointConfiguration().setTimeout(timeout);
        return this;
    }
}

