/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.validation;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.ws.message.SoapAttachment;
import org.citrusframework.ws.validation.AbstractSoapAttachmentValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinarySoapAttachmentValidator
extends AbstractSoapAttachmentValidator {
    private static final Logger logger = LoggerFactory.getLogger(BinarySoapAttachmentValidator.class);

    @Override
    protected void validateAttachmentContent(SoapAttachment receivedAttachment, SoapAttachment controlAttachment) {
        if (logger.isDebugEnabled()) {
            logger.debug("Validating binary SOAP attachment content ...");
        }
        try {
            if (!IOUtils.contentEquals((InputStream)receivedAttachment.getInputStream(), (InputStream)controlAttachment.getInputStream())) {
                throw new ValidationException("Values not equal for binary attachment content '" + Optional.ofNullable(controlAttachment.getContentId()).orElse(Optional.ofNullable(receivedAttachment.getContentId()).orElse("unknown")) + "'");
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Binary SOAP attachment validation failed", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Validating binary SOAP attachment content: OK");
        }
    }
}

