/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.validation;

import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.ws.validation.AbstractFaultDetailValidator;
import org.citrusframework.ws.validation.SoapFaultDetailValidationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSoapFaultValidator
extends AbstractFaultDetailValidator {
    private static final Logger logger = LoggerFactory.getLogger(SimpleSoapFaultValidator.class);

    @Override
    protected void validateFaultDetailString(String received, String control, TestContext context, SoapFaultDetailValidationContext validationContext) throws ValidationException {
        logger.debug("Validating SOAP fault detail ...");
        String receivedDetail = received.replaceAll("\\s", "");
        String controlDetail = control.replaceAll("\\s", "");
        logger.debug("Received fault detail:\n{}", (Object)received.strip());
        logger.debug("Control fault detail:\n{}", (Object)control.strip());
        if (!receivedDetail.equals(controlDetail)) {
            throw new ValidationException("SOAP fault validation failed! Fault detail does not match: expected \n'" + controlDetail + "' \n received \n'" + receivedDetail + "'");
        }
        logger.debug("SOAP fault detail validation successful: All values OK");
    }
}

