/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.xml;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestActionContainerBuilder;
import org.citrusframework.actions.ReceiveMessageAction;
import org.citrusframework.actions.SendMessageAction;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.ws.actions.AssertSoapFault;
import org.citrusframework.ws.actions.ReceiveSoapMessageAction;
import org.citrusframework.ws.actions.SendSoapFaultAction;
import org.citrusframework.ws.actions.SendSoapMessageAction;
import org.citrusframework.ws.actions.SoapActionBuilder;
import org.citrusframework.ws.actions.SoapClientActionBuilder;
import org.citrusframework.ws.actions.SoapServerActionBuilder;
import org.citrusframework.ws.message.SoapAttachment;
import org.citrusframework.xml.TestActions;
import org.citrusframework.xml.actions.Message;
import org.citrusframework.xml.actions.Receive;
import org.citrusframework.xml.actions.Send;

@XmlRootElement(name="soap")
public class Soap
implements TestActionBuilder<TestAction>,
ReferenceResolverAware {
    private TestActionBuilder<?> builder;
    private Receive receive;
    private Send send;
    private String description;
    private String actor;
    private ReferenceResolver referenceResolver;

    @XmlElement
    public Soap setDescription(String value) {
        this.description = value;
        return this;
    }

    @XmlAttribute(name="actor")
    public Soap setActor(String actor) {
        this.actor = actor;
        return this;
    }

    @XmlAttribute(name="client")
    public Soap setSoapClient(String soapClient) {
        this.builder = new SoapActionBuilder().client(soapClient);
        return this;
    }

    @XmlAttribute(name="server")
    public Soap setSoapServer(String soapServer) {
        this.builder = new SoapActionBuilder().server(soapServer);
        return this;
    }

    @XmlElement(name="send-request")
    public Soap setSendRequest(ClientRequest request) {
        SendSoapMessageAction.Builder requestBuilder = this.asClientBuilder().send();
        requestBuilder.name("soap:send-request");
        requestBuilder.description(this.description);
        this.send = new Send(requestBuilder){

            protected SendMessageAction doBuild() {
                return null;
            }
        };
        if (request.fork != null) {
            this.send.setFork(request.fork);
        }
        if (request.extract != null) {
            this.send.setExtract(request.extract);
        }
        if (request.uri != null) {
            ((SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport)requestBuilder.message()).header("citrus_endpoint_uri", request.uri);
        }
        if (request.getMessage() != null) {
            this.send.setMessage((Message)request.getMessage());
            if (request.getMessage().contentType != null) {
                ((SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport)requestBuilder.message()).contentType(request.getMessage().contentType);
            }
            if (request.getMessage().accept != null) {
                ((SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport)requestBuilder.message()).accept(request.getMessage().accept);
            }
            if (request.getMessage().soapAction != null) {
                ((SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport)requestBuilder.message()).soapAction(request.getMessage().soapAction);
            }
            if (request.getMessage().mtomEnabled != null) {
                ((SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport)requestBuilder.message()).mtomEnabled(request.getMessage().mtomEnabled);
            }
            for (SoapMessage.Attachment attachment : request.getMessage().getAttachments()) {
                SoapAttachment soapAttachment = new SoapAttachment();
                soapAttachment.setContentId(attachment.getContentId());
                soapAttachment.setContentType(attachment.getContentType());
                if (attachment.getResource() != null) {
                    soapAttachment.setContentResourcePath(attachment.getResource().getFile());
                }
                if (attachment.getCharset() != null) {
                    soapAttachment.setCharsetName(attachment.getCharset());
                }
                soapAttachment.setContent(attachment.getContent());
                ((SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport)requestBuilder.message()).attachment(soapAttachment);
            }
        }
        this.builder = requestBuilder;
        return this;
    }

    @XmlElement(name="receive-response")
    public Soap setReceiveResponse(ClientResponse response) {
        ReceiveSoapMessageAction.Builder responseBuilder = this.asClientBuilder().receive();
        responseBuilder.name("soap:receive-response");
        responseBuilder.description(this.description);
        this.receive = new Receive(responseBuilder){

            protected ReceiveMessageAction doBuild() {
                return null;
            }
        };
        if (response.getMessage() != null) {
            if (response.getMessage().status != null) {
                ((ReceiveSoapMessageAction.SoapMessageBuilderSupport)responseBuilder.message()).statusCode(Integer.parseInt(response.getMessage().status));
            }
            if (response.getMessage().reasonPhrase != null) {
                ((ReceiveSoapMessageAction.SoapMessageBuilderSupport)responseBuilder.message()).reasonPhrase(response.getMessage().reasonPhrase);
            }
            if (response.getMessage().contentType != null) {
                ((ReceiveSoapMessageAction.SoapMessageBuilderSupport)responseBuilder.message()).contentType(response.getMessage().contentType);
            }
            for (SoapMessage.Attachment attachment : response.getMessage().getAttachments()) {
                SoapAttachment soapAttachment = new SoapAttachment();
                soapAttachment.setContentId(attachment.getContentId());
                soapAttachment.setContentType(attachment.getContentType());
                if (attachment.getResource() != null) {
                    soapAttachment.setContentResourcePath(attachment.getResource().getFile());
                }
                if (attachment.getCharset() != null) {
                    soapAttachment.setCharsetName(attachment.getCharset());
                }
                soapAttachment.setContent(attachment.getContent());
                ((ReceiveSoapMessageAction.SoapMessageBuilderSupport)responseBuilder.message()).attachment(soapAttachment);
            }
            this.receive.setMessage((Message)response.getMessage());
        }
        if (response.attachmentValidator != null) {
            ((ReceiveSoapMessageAction.SoapMessageBuilderSupport)responseBuilder.message()).attachmentValidatorName(response.attachmentValidator);
        }
        if (response.timeout != null) {
            this.receive.setTimeout(response.timeout);
        }
        this.receive.setSelect(response.select);
        this.receive.setValidator(response.validator);
        this.receive.setValidators(response.validators);
        this.receive.setHeaderValidator(response.headerValidator);
        this.receive.setHeaderValidators(response.headerValidators);
        if (response.selector != null) {
            this.receive.setSelector(response.selector);
        }
        this.receive.setSelect(response.select);
        response.getValidates().forEach(this.receive.getValidates()::add);
        if (response.extract != null) {
            this.receive.setExtract(response.extract);
        }
        this.builder = responseBuilder;
        return this;
    }

    @XmlElement(name="receive-request")
    public Soap setReceiveRequest(ServerRequest request) {
        ReceiveSoapMessageAction.Builder requestBuilder = this.asServerBuilder().receive();
        requestBuilder.name("soap:receive-request");
        requestBuilder.description(this.description);
        this.receive = new Receive(requestBuilder){

            protected ReceiveMessageAction doBuild() {
                return null;
            }
        };
        if (request.getMessage() != null) {
            this.receive.setMessage((Message)request.getMessage());
            if (request.getMessage().contentType != null) {
                ((ReceiveSoapMessageAction.SoapMessageBuilderSupport)requestBuilder.message()).contentType(request.getMessage().contentType);
            }
            if (request.getMessage().accept != null) {
                ((ReceiveSoapMessageAction.SoapMessageBuilderSupport)requestBuilder.message()).accept(request.getMessage().accept);
            }
            if (request.getMessage().soapAction != null) {
                ((ReceiveSoapMessageAction.SoapMessageBuilderSupport)requestBuilder.message()).soapAction(request.getMessage().soapAction);
            }
            for (SoapMessage.Attachment attachment : request.getMessage().getAttachments()) {
                SoapAttachment soapAttachment = new SoapAttachment();
                soapAttachment.setContentId(attachment.getContentId());
                soapAttachment.setContentType(attachment.getContentType());
                if (attachment.getResource() != null) {
                    soapAttachment.setContentResourcePath(attachment.getResource().getFile());
                }
                if (attachment.getCharset() != null) {
                    soapAttachment.setCharsetName(attachment.getCharset());
                }
                soapAttachment.setContent(attachment.getContent());
                ((ReceiveSoapMessageAction.SoapMessageBuilderSupport)requestBuilder.message()).attachment(soapAttachment);
            }
        }
        if (request.attachmentValidator != null) {
            ((ReceiveSoapMessageAction.SoapMessageBuilderSupport)requestBuilder.message()).attachmentValidatorName(request.attachmentValidator);
        }
        if (request.selector != null) {
            this.receive.setSelector(request.selector);
        }
        this.receive.setSelect(request.select);
        this.receive.setValidator(request.validator);
        this.receive.setValidators(request.validators);
        this.receive.setHeaderValidator(request.headerValidator);
        this.receive.setHeaderValidators(request.headerValidators);
        if (request.timeout != null) {
            this.receive.setTimeout(request.timeout);
        }
        request.getValidates().forEach(this.receive.getValidates()::add);
        if (request.extract != null) {
            this.receive.setExtract(request.extract);
        }
        this.builder = requestBuilder;
        return this;
    }

    @XmlElement(name="send-response")
    public Soap setSendResponse(ServerResponse response) {
        SendSoapMessageAction.Builder responseBuilder = this.asServerBuilder().send();
        responseBuilder.name("soap:send-response");
        responseBuilder.description(this.description);
        this.send = new Send(responseBuilder){

            protected SendMessageAction doBuild() {
                return null;
            }
        };
        if (response.getMessage() != null) {
            this.send.setMessage((Message)response.getMessage());
            if (response.extract != null) {
                this.send.setExtract(response.extract);
            }
            if (response.getMessage().status != null) {
                ((SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport)responseBuilder.message()).header("citrus_http_status_code", response.getMessage().status);
            }
            if (response.getMessage().reasonPhrase != null) {
                ((SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport)responseBuilder.message()).header("citrus_http_reason_phrase", response.getMessage().reasonPhrase);
            }
            if (response.getMessage().contentType != null) {
                ((SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport)responseBuilder.message()).contentType(response.getMessage().contentType);
            }
            for (SoapMessage.Attachment attachment : response.getMessage().getAttachments()) {
                SoapAttachment soapAttachment = new SoapAttachment();
                soapAttachment.setContentId(attachment.getContentId());
                soapAttachment.setContentType(attachment.getContentType());
                if (attachment.getResource() != null) {
                    soapAttachment.setContentResourcePath(attachment.getResource().getFile());
                }
                if (attachment.getCharset() != null) {
                    soapAttachment.setCharsetName(attachment.getCharset());
                }
                soapAttachment.setContent(attachment.getContent());
                ((SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport)responseBuilder.message()).attachment(soapAttachment);
            }
        }
        this.builder = responseBuilder;
        return this;
    }

    @XmlElement(name="send-fault")
    public void setSendFault(ServerFaultResponse response) {
        SendSoapFaultAction.Builder responseBuilder = this.asServerBuilder().sendFault();
        responseBuilder.name("soap:send-fault");
        responseBuilder.description(this.description);
        this.send = new Send(responseBuilder){

            protected SendMessageAction doBuild() {
                return null;
            }
        };
        if (response.getMessage() != null) {
            this.send.setMessage((Message)response.getMessage());
            if (response.extract != null) {
                this.send.setExtract(response.extract);
            }
            if (response.getMessage().status != null) {
                ((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)responseBuilder.message()).statusCode(Integer.parseInt(response.getMessage().status));
            }
            if (response.getMessage().reasonPhrase != null) {
                ((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)responseBuilder.message()).reasonPhrase(response.getMessage().reasonPhrase);
            }
            if (response.getMessage().faultCode != null) {
                ((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)responseBuilder.message()).faultCode(response.getMessage().faultCode);
            }
            if (response.getMessage().faultString != null) {
                ((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)responseBuilder.message()).faultString(response.getMessage().faultString);
            }
            if (response.getMessage().faultActor != null) {
                ((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)responseBuilder.message()).faultActor(response.getMessage().faultActor);
            }
            for (SoapFault.SoapFaultDetail faultDetail : response.getMessage().getFaultDetails()) {
                if (faultDetail.content != null) {
                    ((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)responseBuilder.message()).faultDetail(faultDetail.getContent().trim());
                }
                if (faultDetail.getResource() == null) continue;
                ((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)responseBuilder.message()).faultDetailResource(faultDetail.getResource().getFile());
            }
            for (SoapMessage.Attachment attachment : response.getMessage().getAttachments()) {
                SoapAttachment soapAttachment = new SoapAttachment();
                soapAttachment.setContentId(attachment.getContentId());
                soapAttachment.setContentType(attachment.getContentType());
                if (attachment.getResource() != null) {
                    soapAttachment.setContentResourcePath(attachment.getResource().getFile());
                }
                if (attachment.getCharset() != null) {
                    soapAttachment.setCharsetName(attachment.getCharset());
                }
                soapAttachment.setContent(attachment.getContent());
                ((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)responseBuilder.message()).attachment(soapAttachment);
            }
        }
        this.builder = responseBuilder;
    }

    @XmlElement(name="assert-fault")
    public void setAssertFault(ClientAssertFault soapFault) {
        AssertSoapFault.Builder assertFault = this.asClientBuilder().assertFault();
        assertFault.name("soap:assert-fault");
        assertFault.description(this.description);
        if (soapFault.faultCode != null) {
            assertFault.faultCode(soapFault.faultCode);
        }
        if (soapFault.faultString != null) {
            assertFault.faultString(soapFault.faultString);
        }
        if (soapFault.faultActor != null) {
            assertFault.faultActor(soapFault.faultActor);
        }
        for (SoapFault.SoapFaultDetail faultDetail : soapFault.getFaultDetails()) {
            if (faultDetail.content != null) {
                assertFault.faultDetail(faultDetail.getContent().trim());
            }
            if (faultDetail.getResource() == null) continue;
            assertFault.faultDetailResource(faultDetail.getResource().getFile());
        }
        if (soapFault.validator != null) {
            assertFault.validator(soapFault.validator);
        }
        if (soapFault.getActions() != null) {
            assertFault.actions((TestActionBuilder<?>[])((TestActionBuilder[])soapFault.getActions().getActionBuilders().toArray(TestActionBuilder[]::new)));
        }
        this.builder = assertFault;
    }

    public TestAction build() {
        if (this.builder == null) {
            throw new CitrusRuntimeException("Missing client or server Soap action - please provide proper action details");
        }
        if (this.send != null) {
            this.send.setReferenceResolver(this.referenceResolver);
            this.send.setActor(this.actor);
            this.send.build();
        }
        if (this.receive != null) {
            this.receive.setReferenceResolver(this.referenceResolver);
            this.receive.setActor(this.actor);
            this.receive.build();
        }
        if (this.builder instanceof TestActionContainerBuilder) {
            ((TestActionContainerBuilder)this.builder).getActions().stream().filter(action -> action instanceof ReferenceResolverAware).forEach(action -> ((ReferenceResolverAware)action).setReferenceResolver(this.referenceResolver));
        }
        if (this.builder instanceof ReferenceResolverAware) {
            ((ReferenceResolverAware)this.builder).setReferenceResolver(this.referenceResolver);
        }
        return this.builder.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    private SoapClientActionBuilder asClientBuilder() {
        if (this.builder instanceof SoapClientActionBuilder) {
            return (SoapClientActionBuilder)this.builder;
        }
        throw new CitrusRuntimeException(String.format("Failed to convert '%s' to soap client action builder", Optional.ofNullable(this.builder).map(Object::getClass).map(Class::getName).orElse("null")));
    }

    private SoapServerActionBuilder asServerBuilder() {
        if (this.builder instanceof SoapServerActionBuilder) {
            return (SoapServerActionBuilder)this.builder;
        }
        throw new CitrusRuntimeException(String.format("Failed to convert '%s' to soap client action builder", Optional.ofNullable(this.builder).map(Object::getClass).map(Class::getName).orElse("null")));
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"message", "extract"})
    public static class ClientRequest {
        @XmlAttribute(name="uri")
        protected String uri;
        @XmlAttribute(name="fork")
        protected Boolean fork;
        @XmlElement(name="message")
        protected SoapRequest message;
        @XmlElement
        protected Message.Extract extract;

        public SoapRequest getMessage() {
            return this.message;
        }

        public void setMessage(SoapRequest message) {
            this.message = message;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public Boolean getFork() {
            return this.fork;
        }

        public void setFork(Boolean fork) {
            this.fork = fork;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="")
    public static class SoapRequest
    extends SoapMessage {
        @XmlAttribute
        protected String path;
        @XmlAttribute(name="content-type")
        protected String contentType;
        @XmlAttribute(name="accept")
        protected String accept;
        @XmlAttribute(name="version")
        protected String version;
        @XmlAttribute(name="soap-action")
        protected String soapAction;
        @XmlAttribute(name="mtom-enabled")
        protected Boolean mtomEnabled;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public String getAccept() {
            return this.accept;
        }

        public void setAccept(String accept) {
            this.accept = accept;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getSoapAction() {
            return this.soapAction;
        }

        public void setSoapAction(String soapAction) {
            this.soapAction = soapAction;
        }

        public Boolean getMtomEnabled() {
            return this.mtomEnabled;
        }

        public void setMtomEnabled(Boolean mtomEnabled) {
            this.mtomEnabled = mtomEnabled;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"attachments"})
    public static class SoapMessage
    extends Message {
        @XmlElement(name="attachment")
        private List<Attachment> attachments;

        public List<Attachment> getAttachments() {
            if (this.attachments == null) {
                this.attachments = new ArrayList<Attachment>();
            }
            return this.attachments;
        }

        public void setAttachments(List<Attachment> attachments) {
            this.attachments = attachments;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"content", "resource"})
        public static class Attachment {
            @XmlAttribute(name="content-id")
            private String contentId;
            @XmlAttribute(name="content-type")
            private String contentType;
            @XmlAttribute(name="charset")
            private String charset;
            @XmlElement
            private String content;
            @XmlElement
            private Resource resource;

            public String getContentId() {
                return this.contentId;
            }

            public void setContentId(String contentId) {
                this.contentId = contentId;
            }

            public String getContentType() {
                return this.contentType;
            }

            public void setContentType(String contentType) {
                this.contentType = contentType;
            }

            public String getContent() {
                return this.content;
            }

            public void setContent(String content) {
                this.content = content;
            }

            public String getCharset() {
                return this.charset;
            }

            public void setCharset(String charset) {
                this.charset = charset;
            }

            public Resource getResource() {
                return this.resource;
            }

            public void setResource(Resource resource) {
                this.resource = resource;
            }

            @XmlAccessorType(value=XmlAccessType.FIELD)
            @XmlType(name="")
            public static class Resource {
                @XmlAttribute(name="file")
                protected String file;

                public String getFile() {
                    return this.file;
                }

                public void setFile(String file) {
                    this.file = file;
                }
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"selector", "message", "validates", "extract"})
    public static class ClientResponse {
        @XmlAttribute
        protected Integer timeout;
        @XmlAttribute
        protected String select;
        @XmlAttribute
        protected String validator;
        @XmlAttribute
        protected String validators;
        @XmlAttribute(name="header-validator")
        protected String headerValidator;
        @XmlAttribute(name="header-validators")
        protected String headerValidators;
        @XmlElement
        protected Receive.Selector selector;
        @XmlElement
        protected SoapResponse message;
        @XmlAttribute(name="attachment-validator")
        protected String attachmentValidator;
        @XmlElement(name="validate")
        protected List<Receive.Validate> validates;
        @XmlElement
        protected Message.Extract extract;

        public SoapResponse getMessage() {
            return this.message;
        }

        public void setMessage(SoapResponse message) {
            this.message = message;
        }

        public String getAttachmentValidator() {
            return this.attachmentValidator;
        }

        public void setAttachmentValidator(String attachmentValidator) {
            this.attachmentValidator = attachmentValidator;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public String getSelect() {
            return this.select;
        }

        public void setSelect(String select) {
            this.select = select;
        }

        public Receive.Selector getSelector() {
            return this.selector;
        }

        public void setSelector(Receive.Selector selector) {
            this.selector = selector;
        }

        public String getValidator() {
            return this.validator;
        }

        public void setValidator(String validator) {
            this.validator = validator;
        }

        public String getValidators() {
            return this.validators;
        }

        public void setValidators(String validators) {
            this.validators = validators;
        }

        public String getHeaderValidator() {
            return this.headerValidator;
        }

        public void setHeaderValidator(String headerValidator) {
            this.headerValidator = headerValidator;
        }

        public String getHeaderValidators() {
            return this.headerValidators;
        }

        public void setHeaderValidators(String headerValidators) {
            this.headerValidators = headerValidators;
        }

        public List<Receive.Validate> getValidates() {
            if (this.validates == null) {
                this.validates = new ArrayList<Receive.Validate>();
            }
            return this.validates;
        }

        public void setValidates(List<Receive.Validate> validates) {
            this.validates = validates;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="")
    public static class SoapResponse
    extends SoapMessage {
        @XmlAttribute(name="status")
        protected String status;
        @XmlAttribute(name="reason-phrase")
        protected String reasonPhrase;
        @XmlAttribute(name="version")
        protected String version;
        @XmlAttribute(name="content-type")
        protected String contentType;

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getReasonPhrase() {
            return this.reasonPhrase;
        }

        public void setReasonPhrase(String reasonPhrase) {
            this.reasonPhrase = reasonPhrase;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"selector", "message", "validates", "extract"})
    public static class ServerRequest {
        @XmlAttribute
        protected Integer timeout;
        @XmlAttribute
        protected String select;
        @XmlAttribute
        protected String validator;
        @XmlAttribute
        protected String validators;
        @XmlAttribute(name="header-validator")
        protected String headerValidator;
        @XmlAttribute(name="header-validators")
        protected String headerValidators;
        @XmlAttribute(name="attachment-validator")
        protected String attachmentValidator;
        @XmlElement
        protected SoapRequest message;
        @XmlElement
        protected Receive.Selector selector;
        @XmlElement(name="validate")
        protected List<Receive.Validate> validates;
        @XmlElement
        protected Message.Extract extract;

        public SoapRequest getMessage() {
            return this.message;
        }

        public void setMessage(SoapRequest message) {
            this.message = message;
        }

        public String getAttachmentValidator() {
            return this.attachmentValidator;
        }

        public void setAttachmentValidator(String attachmentValidator) {
            this.attachmentValidator = attachmentValidator;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public String getSelect() {
            return this.select;
        }

        public void setSelect(String select) {
            this.select = select;
        }

        public String getValidator() {
            return this.validator;
        }

        public void setValidator(String validator) {
            this.validator = validator;
        }

        public String getValidators() {
            return this.validators;
        }

        public void setValidators(String validators) {
            this.validators = validators;
        }

        public String getHeaderValidator() {
            return this.headerValidator;
        }

        public void setHeaderValidator(String headerValidator) {
            this.headerValidator = headerValidator;
        }

        public String getHeaderValidators() {
            return this.headerValidators;
        }

        public void setHeaderValidators(String headerValidators) {
            this.headerValidators = headerValidators;
        }

        public Receive.Selector getSelector() {
            return this.selector;
        }

        public void setSelector(Receive.Selector selector) {
            this.selector = selector;
        }

        public List<Receive.Validate> getValidates() {
            if (this.validates == null) {
                this.validates = new ArrayList<Receive.Validate>();
            }
            return this.validates;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"message", "extract"})
    public static class ServerResponse {
        @XmlElement
        protected SoapResponse message;
        @XmlElement
        protected Message.Extract extract;

        public SoapResponse getMessage() {
            return this.message;
        }

        public void setMessage(SoapResponse message) {
            this.message = message;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"message", "extract"})
    public static class ServerFaultResponse {
        @XmlElement
        protected Message.Extract extract;
        @XmlElement
        protected SoapFault message;

        public SoapFault getMessage() {
            return this.message;
        }

        public void setMessage(SoapFault message) {
            this.message = message;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"faultDetails"})
    public static class SoapFault
    extends SoapResponse {
        @XmlAttribute(name="fault-code")
        protected String faultCode;
        @XmlAttribute(name="fault-string")
        protected String faultString;
        @XmlAttribute(name="fault-actor")
        protected String faultActor;
        @XmlElement(name="fault-detail")
        protected List<SoapFaultDetail> faultDetails;

        public void setFaultCode(String faultCode) {
            this.faultCode = faultCode;
        }

        public String getFaultCode() {
            return this.faultCode;
        }

        public void setFaultString(String faultString) {
            this.faultString = faultString;
        }

        public String getFaultString() {
            return this.faultString;
        }

        public void setFaultActor(String faultActor) {
            this.faultActor = faultActor;
        }

        public String getFaultActor() {
            return this.faultActor;
        }

        public void setFaultDetails(List<SoapFaultDetail> faultDetails) {
            this.faultDetails = faultDetails;
        }

        public List<SoapFaultDetail> getFaultDetails() {
            if (this.faultDetails == null) {
                this.faultDetails = new ArrayList<SoapFaultDetail>();
            }
            return this.faultDetails;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"content", "resource"})
        public static class SoapFaultDetail {
            @XmlElement
            protected String content;
            @XmlElement
            protected Resource resource;

            public void setContent(String content) {
                this.content = content;
            }

            public String getContent() {
                return this.content;
            }

            public void setResource(Resource resource) {
                this.resource = resource;
            }

            public Resource getResource() {
                return this.resource;
            }

            @XmlAccessorType(value=XmlAccessType.FIELD)
            @XmlType(name="")
            public static class Resource {
                @XmlAttribute(name="file", required=true)
                protected String file;

                public String getFile() {
                    return this.file;
                }

                public void setFile(String file) {
                    this.file = file;
                }
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={})
    public static class ClientAssertFault
    extends SoapFault {
        @XmlAttribute
        protected String validator;
        @XmlElement(name="when")
        protected TestActions actions;

        public String getValidator() {
            return this.validator;
        }

        public void setValidator(String validator) {
            this.validator = validator;
        }

        public void setWhen(TestActions actions) {
            this.actions = actions;
        }

        public void setActions(TestActions actions) {
            this.actions = actions;
        }

        public TestActions getActions() {
            return this.actions;
        }
    }
}

