/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.validation;

import java.util.List;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.util.StringUtils;
import org.citrusframework.ws.message.SoapAttachment;
import org.citrusframework.ws.message.SoapMessage;
import org.citrusframework.ws.validation.SoapAttachmentValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ws.mime.Attachment;

public abstract class AbstractSoapAttachmentValidator
implements SoapAttachmentValidator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSoapAttachmentValidator.class);

    @Override
    public void validateAttachment(SoapMessage soapMessage, List<SoapAttachment> controlAttachments) {
        logger.debug("Validating SOAP attachments ...");
        for (SoapAttachment controlAttachment : controlAttachments) {
            SoapAttachment attachment = this.findAttachment(soapMessage, controlAttachment);
            logger.debug("Found attachment with contentId '{}'", (Object)controlAttachment.getContentId());
            this.validateAttachmentContentId(attachment, controlAttachment);
            this.validateAttachmentContentType(attachment, controlAttachment);
            this.validateAttachmentContent(attachment, controlAttachment);
            logger.debug("SOAP attachment validation successful: All values OK");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected SoapAttachment findAttachment(SoapMessage soapMessage, SoapAttachment controlAttachment) {
        List<SoapAttachment> attachments = soapMessage.getAttachments();
        Attachment matching = null;
        if (controlAttachment.getContentId() == null) {
            if (attachments.size() != 1) throw new ValidationException("Found more than one SOAP attachment - need control attachment content id for validation!");
            matching = attachments.get(0);
        } else {
            for (Attachment attachment : attachments) {
                if (controlAttachment.getContentId() == null || !controlAttachment.getContentId().equals(attachment.getContentId())) continue;
                matching = attachment;
            }
        }
        if (matching == null) throw new ValidationException(String.format("Unable to find SOAP attachment with content id '%s'", controlAttachment.getContentId()));
        return SoapAttachment.from(matching);
    }

    protected void validateAttachmentContentId(SoapAttachment receivedAttachment, SoapAttachment controlAttachment) {
        if (!StringUtils.hasText((String)controlAttachment.getContentId())) {
            return;
        }
        if (receivedAttachment.getContentId() != null) {
            if (controlAttachment.getContentId() == null) {
                throw new ValidationException(this.buildValidationErrorMessage("Values not equal for attachment contentId", null, receivedAttachment.getContentId()));
            }
            if (!receivedAttachment.getContentId().equals(controlAttachment.getContentId())) {
                throw new ValidationException(this.buildValidationErrorMessage("Values not equal for attachment contentId", controlAttachment.getContentId(), receivedAttachment.getContentId()));
            }
        } else if (StringUtils.hasText((String)controlAttachment.getContentId())) {
            throw new ValidationException(this.buildValidationErrorMessage("Values not equal for attachment contentId", controlAttachment.getContentId(), null));
        }
        logger.debug("Validating attachment contentId: {}='{}': OK", (Object)receivedAttachment.getContentId(), (Object)controlAttachment.getContentId());
    }

    protected void validateAttachmentContentType(SoapAttachment receivedAttachment, SoapAttachment controlAttachment) {
        if (!StringUtils.hasText((String)controlAttachment.getContentType())) {
            return;
        }
        if (receivedAttachment.getContentType() != null) {
            if (controlAttachment.getContentType() == null) {
                throw new ValidationException(this.buildValidationErrorMessage("Values not equal for attachment contentType", null, receivedAttachment.getContentType()));
            }
            if (!receivedAttachment.getContentType().equals(controlAttachment.getContentType())) {
                throw new ValidationException(this.buildValidationErrorMessage("Values not equal for attachment contentType", controlAttachment.getContentType(), receivedAttachment.getContentType()));
            }
        } else if (StringUtils.hasText((String)controlAttachment.getContentType())) {
            throw new ValidationException(this.buildValidationErrorMessage("Values not equal for attachment contentType", controlAttachment.getContentType(), null));
        }
        logger.debug("Validating attachment contentType: {}='{}': OK", (Object)receivedAttachment.getContentType(), (Object)controlAttachment.getContentType());
    }

    private String buildValidationErrorMessage(String message, Object expectedValue, Object actualValue) {
        return message + ", expected '" + expectedValue + "' but was '" + actualValue + "'";
    }

    protected abstract void validateAttachmentContent(SoapAttachment var1, SoapAttachment var2);
}

