/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.validation;

import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.util.StringUtils;
import org.citrusframework.ws.message.SoapAttachment;
import org.citrusframework.ws.validation.AbstractSoapAttachmentValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSoapAttachmentValidator
extends AbstractSoapAttachmentValidator {
    private boolean ignoreAllWhitespaces = false;
    private static final Logger logger = LoggerFactory.getLogger(SimpleSoapAttachmentValidator.class);

    @Override
    protected void validateAttachmentContent(SoapAttachment receivedAttachment, SoapAttachment controlAttachment) {
        String receivedContent = receivedAttachment.getContent().replaceAll("\\s", "");
        String controlContent = controlAttachment.getContent().replaceAll("\\s", "");
        if (logger.isDebugEnabled()) {
            logger.debug("Validating SOAP attachment content ...");
            logger.debug("Received attachment content: " + receivedContent);
            logger.debug("Control attachment content: " + controlContent);
        }
        if (StringUtils.hasText((String)receivedContent)) {
            if (!StringUtils.hasText((String)controlContent)) {
                throw new ValidationException("Values not equal for attachment content '" + controlAttachment.getContentId() + "', expected '" + controlContent + "' but was '" + receivedContent + "'");
            }
            this.validateAttachmentContentData(receivedContent, controlContent, controlAttachment.getContentId());
        } else if (StringUtils.hasText((String)controlContent)) {
            throw new ValidationException("Values not equal for attachment content '" + controlAttachment.getContentId() + "', expected '" + controlContent + "' but was '" + receivedContent + "'");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Validating attachment content: OK");
        }
    }

    protected void validateAttachmentContentData(String receivedContent, String controlContent, String controlContentId) {
        if (this.ignoreAllWhitespaces) {
            controlContent = controlContent.replaceAll("\\s", "");
            receivedContent = receivedContent.replaceAll("\\s", "");
        }
        if (!receivedContent.equals(controlContent)) {
            throw new ValidationException("Values not equal for attachment content '" + controlContentId + "', expected '" + controlContent.trim() + "' but was '" + receivedContent.trim() + "'");
        }
    }

    public boolean isIgnoreAllWhitespaces() {
        return this.ignoreAllWhitespaces;
    }

    public void setIgnoreAllWhitespaces(boolean ignoreAllWhitespaces) {
        this.ignoreAllWhitespaces = ignoreAllWhitespaces;
    }
}

