/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.actions;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.citrusframework.TestAction;
import org.citrusframework.actions.ReceiveMessageAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageBuilder;
import org.citrusframework.message.builder.ReceiveMessageBuilderSupport;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.validation.builder.StaticMessageBuilder;
import org.citrusframework.ws.message.SoapAttachment;
import org.citrusframework.ws.message.SoapMessage;
import org.citrusframework.ws.message.SoapMessageUtils;
import org.citrusframework.ws.validation.SimpleSoapAttachmentValidator;
import org.citrusframework.ws.validation.SoapAttachmentValidator;
import org.springframework.http.HttpStatus;

public class ReceiveSoapMessageAction
extends ReceiveMessageAction
implements TestAction {
    private final List<SoapAttachment> attachments;
    private final SoapAttachmentValidator attachmentValidator;

    public ReceiveSoapMessageAction(Builder builder) {
        super((ReceiveMessageAction.ReceiveMessageActionBuilder)builder);
        this.attachments = builder.attachments;
        this.attachmentValidator = builder.attachmentValidator;
    }

    protected void validateMessage(Message message, TestContext context) {
        super.validateMessage(message, context);
        if (!this.attachments.isEmpty() && !(message instanceof SoapMessage)) {
            throw new CitrusRuntimeException(String.format("Unable to perform SOAP attachment validation on message type '%s'", message.getClass()));
        }
        for (SoapAttachment attachment : this.attachments) {
            attachment.setTestContext(context);
        }
        if (!this.attachments.isEmpty()) {
            this.attachmentValidator.validateAttachment((SoapMessage)message, this.attachments);
        }
    }

    public List<SoapAttachment> getAttachments() {
        return this.attachments;
    }

    public SoapAttachmentValidator getAttachmentValidator() {
        return this.attachmentValidator;
    }

    public static final class Builder
    extends ReceiveMessageAction.ReceiveMessageActionBuilder<ReceiveSoapMessageAction, SoapMessageBuilderSupport, Builder> {
        private final SoapMessage soapMessage = new SoapMessage();
        private final List<SoapAttachment> attachments = new ArrayList<SoapAttachment>();
        private SoapAttachmentValidator attachmentValidator = new SimpleSoapAttachmentValidator();
        private String attachmentValidatorName;

        public Builder() {
            ((SoapMessageBuilderSupport)this.message((MessageBuilder)new StaticMessageBuilder((Message)this.soapMessage))).headerNameIgnoreCase(true);
        }

        public SoapMessageBuilderSupport getMessageBuilderSupport() {
            if (this.messageBuilderSupport == null) {
                this.messageBuilderSupport = new SoapMessageBuilderSupport(this.soapMessage, this);
            }
            return (SoapMessageBuilderSupport)super.getMessageBuilderSupport();
        }

        public ReceiveSoapMessageAction doBuild() {
            if (this.referenceResolver != null) {
                if (this.attachmentValidatorName != null) {
                    this.attachmentValidator = (SoapAttachmentValidator)this.referenceResolver.resolve(this.attachmentValidatorName, SoapAttachmentValidator.class);
                } else if (this.referenceResolver.isResolvable(SoapAttachmentValidator.class)) {
                    this.attachmentValidator = (SoapAttachmentValidator)this.referenceResolver.resolve(SoapAttachmentValidator.class);
                }
            }
            return new ReceiveSoapMessageAction(this);
        }
    }

    public static class SoapMessageBuilderSupport
    extends ReceiveMessageBuilderSupport<ReceiveSoapMessageAction, Builder, SoapMessageBuilderSupport> {
        private final SoapMessage soapMessage;

        protected SoapMessageBuilderSupport(SoapMessage soapMessage, Builder delegate) {
            super((ReceiveMessageAction.ReceiveMessageActionBuilder)delegate);
            this.soapMessage = soapMessage;
        }

        public SoapMessageBuilderSupport body(String payload) {
            this.soapMessage.setPayload(payload);
            return this;
        }

        public SoapMessageBuilderSupport name(String name) {
            this.soapMessage.setName(name);
            return (SoapMessageBuilderSupport)super.name(name);
        }

        public SoapMessageBuilderSupport from(Message controlMessage) {
            SoapMessageUtils.copy(controlMessage, this.soapMessage);
            this.type(controlMessage.getType());
            return this;
        }

        public SoapMessageBuilderSupport soapAction(String soapAction) {
            this.soapMessage.header("citrus_soap_action", soapAction);
            return this;
        }

        public SoapMessageBuilderSupport attachment(String contentId, String contentType, String content) {
            SoapAttachment attachment = new SoapAttachment();
            attachment.setContentId(contentId);
            attachment.setContentType(contentType);
            attachment.setContent(content);
            this.attachment(attachment);
            return this;
        }

        public SoapMessageBuilderSupport attachment(String contentId, String contentType, Resource contentResource) {
            return this.attachment(contentId, contentType, contentResource, FileUtils.getDefaultCharset());
        }

        public SoapMessageBuilderSupport attachment(String contentId, String contentType, Resource contentResource, Charset charset) {
            SoapAttachment attachment = new SoapAttachment();
            attachment.setContentId(contentId);
            attachment.setContentType(contentType);
            attachment.setCharsetName(charset.name());
            try {
                attachment.setContent(FileUtils.readToString((Resource)contentResource, (Charset)charset));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read attachment content resource", (Throwable)e);
            }
            this.attachment(attachment);
            return this;
        }

        public SoapMessageBuilderSupport charset(String charsetName) {
            if (!((Builder)this.delegate).attachments.isEmpty()) {
                ((Builder)this.delegate).attachments.get(((Builder)this.delegate).attachments.size() - 1).setCharsetName(charsetName);
            }
            return this;
        }

        public SoapMessageBuilderSupport attachment(SoapAttachment attachment) {
            ((Builder)this.delegate).attachments.add(attachment);
            return this;
        }

        public SoapMessageBuilderSupport attachmentValidatorName(String validator) {
            ((Builder)this.delegate).attachmentValidatorName = validator;
            return this;
        }

        public SoapMessageBuilderSupport attachmentValidator(SoapAttachmentValidator validator) {
            ((Builder)this.delegate).attachmentValidator = validator;
            return this;
        }

        public SoapMessageBuilderSupport contentType(String contentType) {
            this.soapMessage.contentType(contentType);
            return this;
        }

        public SoapMessageBuilderSupport accept(String accept) {
            this.soapMessage.accept(accept);
            return this;
        }

        public SoapMessageBuilderSupport reasonPhrase(String reasonPhrase) {
            this.soapMessage.reasonPhrase(reasonPhrase);
            return this;
        }

        public SoapMessageBuilderSupport status(HttpStatus status) {
            this.soapMessage.status(status);
            return this;
        }

        public SoapMessageBuilderSupport statusCode(Integer statusCode) {
            this.soapMessage.statusCode(statusCode);
            return this;
        }

        public SoapMessageBuilderSupport contextPath(String contextPath) {
            this.soapMessage.header("citrus_http_context_path", contextPath);
            return this;
        }
    }
}

