/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.servlet;

import java.util.ArrayList;
import java.util.List;
import org.citrusframework.endpoint.EndpointAdapter;
import org.citrusframework.util.StringUtils;
import org.citrusframework.ws.client.WebServiceEndpointConfiguration;
import org.citrusframework.ws.interceptor.DelegatingEndpointInterceptor;
import org.citrusframework.ws.server.WebServiceEndpoint;
import org.citrusframework.ws.server.WebServiceServer;
import org.springframework.context.ApplicationContext;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.transport.http.MessageDispatcherServlet;

public class CitrusMessageDispatcherServlet
extends MessageDispatcherServlet {
    private WebServiceServer webServiceServer;
    private static final String ENDPOINT_INTERCEPTOR_BEAN_NAME = "citrusEndpointInterceptor";
    private static final String MESSAGE_ENDPOINT_BEAN_NAME = "citrusWsEndpoint";

    public CitrusMessageDispatcherServlet(WebServiceServer webServiceServer) {
        this.webServiceServer = webServiceServer;
        this.setMessageFactoryBeanName(webServiceServer.getMessageFactoryName());
    }

    protected void initStrategies(ApplicationContext context) {
        super.initStrategies(context);
        this.configureHandlerInterceptor(context);
        this.configureMessageEndpoint(context);
    }

    protected void configureHandlerInterceptor(ApplicationContext context) {
        if (context.containsBean(ENDPOINT_INTERCEPTOR_BEAN_NAME)) {
            DelegatingEndpointInterceptor endpointInterceptor = (DelegatingEndpointInterceptor)context.getBean(ENDPOINT_INTERCEPTOR_BEAN_NAME, DelegatingEndpointInterceptor.class);
            endpointInterceptor.setInterceptors(this.adaptInterceptors(this.webServiceServer.getInterceptors()));
        }
    }

    protected void configureMessageEndpoint(ApplicationContext context) {
        if (context.containsBean(MESSAGE_ENDPOINT_BEAN_NAME)) {
            WebServiceEndpoint messageEndpoint = (WebServiceEndpoint)context.getBean(MESSAGE_ENDPOINT_BEAN_NAME, WebServiceEndpoint.class);
            EndpointAdapter endpointAdapter = this.webServiceServer.getEndpointAdapter();
            if (endpointAdapter != null) {
                messageEndpoint.setEndpointAdapter(endpointAdapter);
            }
            WebServiceEndpointConfiguration endpointConfiguration = new WebServiceEndpointConfiguration();
            endpointConfiguration.setHandleMimeHeaders(this.webServiceServer.isHandleMimeHeaders());
            endpointConfiguration.setHandleAttributeHeaders(this.webServiceServer.isHandleAttributeHeaders());
            endpointConfiguration.setKeepSoapEnvelope(this.webServiceServer.isKeepSoapEnvelope());
            endpointConfiguration.setMessageConverter(this.webServiceServer.getMessageConverter());
            messageEndpoint.setEndpointConfiguration(endpointConfiguration);
            if (StringUtils.hasText((String)this.webServiceServer.getSoapHeaderNamespace())) {
                messageEndpoint.setDefaultNamespaceUri(this.webServiceServer.getSoapHeaderNamespace());
            }
            if (StringUtils.hasText((String)this.webServiceServer.getSoapHeaderPrefix())) {
                messageEndpoint.setDefaultPrefix(this.webServiceServer.getSoapHeaderPrefix());
            }
        }
    }

    private List<EndpointInterceptor> adaptInterceptors(List<Object> interceptors) {
        ArrayList<EndpointInterceptor> endpointInterceptors = new ArrayList<EndpointInterceptor>();
        if (interceptors != null) {
            for (Object interceptor : interceptors) {
                if (!(interceptor instanceof EndpointInterceptor)) continue;
                endpointInterceptors.add((EndpointInterceptor)interceptor);
            }
        }
        return endpointInterceptors;
    }
}

