/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.actions;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.citrusframework.AbstractTestContainerBuilder;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.container.AbstractActionContainer;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.message.builder.MessageBuilderSupport;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;
import org.citrusframework.ws.message.SoapFault;
import org.citrusframework.ws.validation.SimpleSoapFaultValidator;
import org.citrusframework.ws.validation.SoapFaultDetailValidationContext;
import org.citrusframework.ws.validation.SoapFaultValidationContext;
import org.citrusframework.ws.validation.SoapFaultValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ws.soap.client.SoapFaultClientException;

public class AssertSoapFault
extends AbstractActionContainer {
    private final TestAction action;
    private final String faultString;
    private final String faultCode;
    private final String faultActor;
    private final List<String> faultDetails;
    private final List<String> faultDetailResourcePaths;
    private final SoapFaultValidator validator;
    private final SoapFaultValidationContext validationContext;
    private static final Logger logger = LoggerFactory.getLogger(AssertSoapFault.class);

    public AssertSoapFault(Builder builder) {
        super("soap-fault", (AbstractTestContainerBuilder)builder);
        this.action = builder.action.build();
        this.faultString = builder.faultString;
        this.faultCode = builder.faultCode;
        this.faultActor = builder.faultActor;
        this.faultDetails = builder.faultDetails;
        this.faultDetailResourcePaths = builder.faultDetailResourcePaths;
        this.validator = builder.validator;
        this.validationContext = builder.validationContext.build();
    }

    public void doExecute(TestContext context) {
        logger.debug("Asserting SOAP fault ...");
        try {
            this.executeAction(this.action, context);
        }
        catch (SoapFaultClientException soapFaultException) {
            logger.debug("Validating SOAP fault ...");
            SoapFault controlFault = this.constructControlFault(context);
            this.validator.validateSoapFault(SoapFault.from(soapFaultException.getSoapFault()), controlFault, context, this.validationContext);
            logger.debug("Asserted SOAP fault as expected: {}: {}", (Object)soapFaultException.getFaultCode(), (Object)soapFaultException.getFaultStringOrReason());
            logger.debug("Assert SOAP fault validation successful");
            return;
        }
        catch (Exception e) {
            throw new ValidationException("SOAP fault validation failed for asserted exception type - expected: '" + SoapFaultClientException.class + "' but was: '" + e.getClass().getName() + "'", (Throwable)e);
        }
        throw new ValidationException("SOAP fault validation failed! Missing asserted SOAP fault exception");
    }

    private SoapFault constructControlFault(TestContext context) {
        SoapFault controlFault = new SoapFault();
        if (StringUtils.hasText((String)this.faultActor)) {
            controlFault.faultActor(context.replaceDynamicContentInString(this.faultActor));
        }
        controlFault.faultCode(context.replaceDynamicContentInString(this.faultCode));
        controlFault.faultString(context.replaceDynamicContentInString(this.faultString));
        for (String faultDetail : this.faultDetails) {
            controlFault.addFaultDetail(context.replaceDynamicContentInString(faultDetail));
        }
        try {
            for (String faultDetailPath : this.faultDetailResourcePaths) {
                String resourcePath = context.replaceDynamicContentInString(faultDetailPath);
                controlFault.addFaultDetail(context.replaceDynamicContentInString(FileUtils.readToString((Resource)FileUtils.getFileResource((String)resourcePath, (TestContext)context), (Charset)FileUtils.getCharset((String)resourcePath))));
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to create SOAP fault detail from file resource", (Throwable)e);
        }
        return controlFault;
    }

    public TestAction getAction() {
        return this.action;
    }

    public TestAction getTestAction(int index) {
        return this.action;
    }

    public List<TestAction> getActions() {
        return Collections.singletonList(this.action);
    }

    public String getFaultString() {
        return this.faultString;
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public List<String> getFaultDetails() {
        return this.faultDetails;
    }

    public List<String> getFaultDetailResourcePaths() {
        return this.faultDetailResourcePaths;
    }

    public SoapFaultValidator getValidator() {
        return this.validator;
    }

    public String getFaultActor() {
        return this.faultActor;
    }

    public SoapFaultValidationContext getValidationContext() {
        return this.validationContext;
    }

    public static class Builder
    extends AbstractTestContainerBuilder<AssertSoapFault, Builder>
    implements ReferenceResolverAware {
        private TestActionBuilder<?> action;
        protected Endpoint endpoint;
        protected String endpointUri;
        private String faultString;
        private String faultCode;
        private String faultActor;
        private final List<String> faultDetails = new ArrayList<String>();
        private final List<String> faultDetailResourcePaths = new ArrayList<String>();
        private String validatorName;
        private SoapFaultValidator validator;
        private SoapFaultValidationContext.Builder validationContext;
        private ReferenceResolver referenceResolver;

        public static Builder assertSoapFault() {
            return new Builder();
        }

        public Builder when(TestAction action) {
            return this.when(() -> action);
        }

        public Builder when(TestActionBuilder<?> action) {
            return this.actions((TestActionBuilder<?>[])new TestActionBuilder[]{action});
        }

        public Builder actions(TestActionBuilder<?> ... actions) {
            this.action = actions[0];
            if (this.action instanceof MessageBuilderSupport.MessageActionBuilder) {
                if (this.endpointUri != null) {
                    ((MessageBuilderSupport.MessageActionBuilder)this.action).endpoint(this.endpointUri);
                }
                if (this.endpoint != null) {
                    ((MessageBuilderSupport.MessageActionBuilder)this.action).endpoint(this.endpoint);
                }
            }
            return (Builder)super.actions(new TestActionBuilder[]{actions[0]});
        }

        public Builder endpoint(Endpoint messageEndpoint) {
            this.endpoint = messageEndpoint;
            return this;
        }

        public Builder endpoint(String messageEndpointUri) {
            this.endpointUri = messageEndpointUri;
            return this;
        }

        public Builder faultCode(String code) {
            this.faultCode = code;
            return this;
        }

        public Builder faultString(String faultString) {
            this.faultString = faultString;
            return this;
        }

        public Builder faultActor(String faultActor) {
            this.faultActor = faultActor;
            return this;
        }

        public Builder faultDetail(String faultDetail) {
            this.faultDetails.add(faultDetail);
            return this;
        }

        public Builder faultDetailResource(Resource resource) {
            return this.faultDetailResource(resource, FileUtils.getDefaultCharset());
        }

        public Builder faultDetailResource(Resource resource, Charset charset) {
            try {
                this.faultDetails.add(FileUtils.readToString((Resource)resource, (Charset)charset));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read fault detail resource", (Throwable)e);
            }
            return this;
        }

        public Builder faultDetailResource(String filePath) {
            this.faultDetailResourcePaths.add(filePath);
            return this;
        }

        public Builder validator(SoapFaultValidator validator) {
            this.validator = validator;
            return this;
        }

        public Builder validator(String validatorName) {
            this.validatorName = validatorName;
            return this;
        }

        public Builder validate(SoapFaultValidationContext.Builder validationContext) {
            this.validationContext = validationContext;
            return this;
        }

        public Builder validateDetail(SoapFaultDetailValidationContext.Builder validationContext) {
            if (this.validationContext == null) {
                this.validationContext = new SoapFaultValidationContext.Builder();
            }
            this.validationContext.detail(validationContext.build());
            return this;
        }

        public Builder withReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
            return this;
        }

        public void setReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
        }

        public AssertSoapFault build() {
            return this.doBuild();
        }

        public AssertSoapFault doBuild() {
            if (this.validationContext == null) {
                this.validationContext = new SoapFaultValidationContext.Builder();
                if (!this.faultDetailResourcePaths.isEmpty() || !this.faultDetails.isEmpty()) {
                    this.validationContext.detail(new SoapFaultDetailValidationContext.Builder().build());
                }
            }
            if (this.referenceResolver != null) {
                if (StringUtils.hasText((String)this.validatorName)) {
                    this.validator((SoapFaultValidator)this.referenceResolver.resolve(this.validatorName, SoapFaultValidator.class));
                }
                if (this.validator == null && this.referenceResolver.isResolvable("soapFaultValidator")) {
                    this.validator((SoapFaultValidator)this.referenceResolver.resolve("soapFaultValidator", SoapFaultValidator.class));
                }
            }
            if (this.validator == null) {
                this.validator = new SimpleSoapFaultValidator();
            }
            return new AssertSoapFault(this);
        }
    }
}

