/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.interceptor;

import java.util.ArrayList;
import java.util.List;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.server.SmartEndpointInterceptor;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.server.SoapEndpointInterceptor;

public class DelegatingEndpointInterceptor
implements SmartEndpointInterceptor,
SoapEndpointInterceptor {
    private List<EndpointInterceptor> interceptors = new ArrayList<EndpointInterceptor>();

    public boolean shouldIntercept(MessageContext messageContext, Object endpoint) {
        return true;
    }

    public boolean handleRequest(MessageContext messageContext, Object endpoint) throws Exception {
        for (EndpointInterceptor interceptor : this.interceptors) {
            if (!this.shouldIntercept(interceptor, messageContext, endpoint) || interceptor.handleRequest(messageContext, endpoint)) continue;
            return false;
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext, Object endpoint) throws Exception {
        for (EndpointInterceptor interceptor : this.interceptors) {
            if (!this.shouldIntercept(interceptor, messageContext, endpoint) || interceptor.handleResponse(messageContext, endpoint)) continue;
            return false;
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext, Object endpoint) throws Exception {
        for (EndpointInterceptor interceptor : this.interceptors) {
            if (!this.shouldIntercept(interceptor, messageContext, endpoint) || interceptor.handleFault(messageContext, endpoint)) continue;
            return false;
        }
        return true;
    }

    public void afterCompletion(MessageContext messageContext, Object endpoint, Exception ex) throws Exception {
        for (EndpointInterceptor interceptor : this.interceptors) {
            if (!this.shouldIntercept(interceptor, messageContext, endpoint)) continue;
            interceptor.afterCompletion(messageContext, endpoint, ex);
        }
    }

    public boolean understands(SoapHeaderElement header) {
        for (EndpointInterceptor interceptor : this.interceptors) {
            if (!(interceptor instanceof SoapEndpointInterceptor) || !((SoapEndpointInterceptor)interceptor).understands(header)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldIntercept(EndpointInterceptor interceptor, MessageContext messageContext, Object endpoint) {
        if (interceptor instanceof SmartEndpointInterceptor) {
            return ((SmartEndpointInterceptor)interceptor).shouldIntercept(messageContext, endpoint);
        }
        return true;
    }

    public List<EndpointInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<EndpointInterceptor> interceptors) {
        this.interceptors = interceptors;
    }
}

