/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaml;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import org.citrusframework.DefaultTestCase;
import org.citrusframework.TestCase;
import org.citrusframework.TestCaseMetaInfo;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.variable.VariableUtils;
import org.citrusframework.yaml.TestActions;
import org.citrusframework.yaml.actions.script.ScriptDefinitionType;

public class YamlTestCase {
    private final DefaultTestCase delegate = new DefaultTestCase();

    public TestCase getTestCase() {
        return this.delegate;
    }

    public void setName(String name) {
        this.delegate.setName(name);
    }

    public void setDescription(String description) {
        this.delegate.setDescription(description);
    }

    public void setAuthor(String author) {
        this.delegate.getMetaInfo().setAuthor(author);
    }

    public void setStatus(TestCaseMetaInfo.Status status) {
        this.delegate.getMetaInfo().setStatus(status);
    }

    public void setVariables(List<Variable> variables) {
        variables.forEach(variable -> {
            if (variable.script != null) {
                if (variable.script.getFile() != null) {
                    try {
                        this.delegate.getVariableDefinitions().put(variable.name, VariableUtils.getValueFromScript((String)variable.script.getType(), (String)FileUtils.readToString((Resource)FileUtils.getFileResource((String)variable.script.getFile()), (Charset)Optional.ofNullable(variable.script.getCharset()).map(Charset::forName).orElseGet(FileUtils::getDefaultCharset))));
                    }
                    catch (IOException e) {
                        throw new CitrusRuntimeException("Failed to read script file resource", (Throwable)e);
                    }
                } else {
                    this.delegate.getVariableDefinitions().put(variable.name, VariableUtils.getValueFromScript((String)variable.script.getType(), (String)variable.script.getValue()));
                }
            } else {
                this.delegate.getVariableDefinitions().put(variable.name, variable.value);
            }
        });
    }

    public void setActions(List<TestActions> actions) {
        actions.forEach(action -> this.delegate.addTestAction(action.get()));
    }

    public void setFinally(List<TestActions> actions) {
        actions.forEach(action -> this.delegate.addFinalAction(action.get()));
    }

    public static class Variable {
        protected ScriptDefinitionType script;
        protected String name;
        protected String value;

        public ScriptDefinitionType getScript() {
            return this.script;
        }

        public void setScript(ScriptDefinitionType value) {
            this.script = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            this.name = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

