/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaml.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.actions.CreateVariablesAction;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;

public class CreateVariables
implements TestActionBuilder<CreateVariablesAction> {
    private final CreateVariablesAction.Builder builder = new CreateVariablesAction.Builder();
    protected List<Variable> variables = new ArrayList<Variable>();

    public CreateVariablesAction build() {
        for (Variable variable : this.variables) {
            if (variable.getScript() != null) {
                if (variable.getScript().getFile() != null) {
                    try {
                        this.builder.variable(variable.getName(), FileUtils.readToString((Resource)FileUtils.getFileResource((String)variable.getScript().getFile())));
                        continue;
                    }
                    catch (IOException e) {
                        throw new CitrusRuntimeException("Failed to read variable script file resource", (Throwable)e);
                    }
                }
                this.builder.variable(variable.getName(), String.format("script:<%s>%s", Optional.ofNullable(variable.getScript().getType()).orElse("groovy"), variable.getScript().getValue().trim()));
                continue;
            }
            this.builder.variable(variable.getName(), variable.getValue().trim());
        }
        return this.builder.build();
    }

    public void setDescription(String value) {
        this.builder.description(value);
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    public static class Variable {
        protected String name;
        protected String value;
        protected Script script;

        public Script getScript() {
            return this.script;
        }

        public void setScript(Script value) {
            this.script = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            this.name = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public static class Script {
            protected String value;
            protected String type;
            protected String file;

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public String getType() {
                return this.type;
            }

            public void setType(String value) {
                this.type = value;
            }

            public String getFile() {
                return this.file;
            }

            public void setFile(String value) {
                this.file = value;
            }
        }
    }
}

