/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaml.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.actions.PurgeEndpointAction;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;

public class PurgeEndpoint
implements TestActionBuilder<PurgeEndpointAction>,
ReferenceResolverAware {
    private final PurgeEndpointAction.Builder builder = new PurgeEndpointAction.Builder();
    private ReferenceResolver referenceResolver;
    protected List<Endpoint> endpoints;

    public PurgeEndpoint setEndpoint(String endpoint) {
        this.builder.endpoint(endpoint);
        return this;
    }

    public List<Endpoint> getEndpoints() {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<Endpoint>();
        }
        return this.endpoints;
    }

    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public void setTimeout(long milliseconds) {
        this.builder.timeout(milliseconds);
    }

    public void setSleep(long milliseconds) {
        this.builder.sleep(milliseconds);
    }

    public void setSelect(String value) {
        this.builder.selector(value);
    }

    public void setSelector(Selector selector) {
        if (selector.value != null) {
            this.builder.selector(selector.value);
        }
        if (selector.elements != null) {
            HashMap<String, String> selectorElements = new HashMap<String, String>();
            for (Selector.Element element : selector.elements) {
                selectorElements.put(element.name, element.value);
            }
            this.builder.selector(selectorElements);
        }
    }

    public PurgeEndpointAction build() {
        this.builder.withReferenceResolver(this.referenceResolver);
        for (Endpoint endpoint : this.endpoints) {
            if (endpoint.getName() != null) {
                this.builder.endpoint(endpoint.name);
            }
            if (this.referenceResolver == null || endpoint.getRef() == null) continue;
            this.builder.endpoint((org.citrusframework.endpoint.Endpoint)this.referenceResolver.resolve(endpoint.ref, org.citrusframework.endpoint.Endpoint.class));
        }
        return this.builder.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    public static class Selector {
        protected List<Element> elements;
        protected String value;

        public List<Element> getElements() {
            if (this.elements == null) {
                this.elements = new ArrayList<Element>();
            }
            return this.elements;
        }

        public void setElements(List<Element> elements) {
            this.elements = elements;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public static class Element {
            protected String name;
            protected String value;

            public String getName() {
                return this.name;
            }

            public void setName(String value) {
                this.name = value;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }

    public static class Endpoint {
        protected String name;
        protected String ref;

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            this.name = value;
        }

        public void setRef(String ref) {
            this.ref = ref;
        }

        public String getRef() {
            return this.ref;
        }
    }
}

