/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaml.actions;

import java.util.Map;
import java.util.Optional;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface YamlTestActionBuilder {
    public static final Logger logger = LoggerFactory.getLogger(YamlTestActionBuilder.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/yaml/builder";
    public static final ResourcePathTypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/yaml/builder");

    public static Map<String, TestActionBuilder<?>> lookup() {
        Map builders = TYPE_RESOLVER.resolveAll();
        if (logger.isDebugEnabled()) {
            builders.forEach((k, v) -> logger.debug(String.format("Found YAML test action builder '%s' as %s", k, v.getClass())));
        }
        return builders;
    }

    public static Optional<TestActionBuilder<?>> lookup(String name) {
        try {
            return Optional.of((TestActionBuilder)TYPE_RESOLVER.resolve(name, new Object[0]));
        }
        catch (CitrusRuntimeException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Failed to resolve test action builder from resource '%s/%s'", RESOURCE_PATH, name), (Throwable)e);
            } else {
                logger.warn(String.format("Failed to resolve test action builder from resource '%s/%s'", RESOURCE_PATH, name));
            }
            return Optional.empty();
        }
    }
}

