/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaml;

import java.io.IOException;
import org.citrusframework.container.TemplateLoader;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.yaml.container.Template;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class YamlTemplateLoader
implements ReferenceResolverAware,
TemplateLoader {
    private final Yaml yaml = new Yaml((BaseConstructor)new Constructor(Template.class, new LoaderOptions()));
    private ReferenceResolver referenceResolver;

    public org.citrusframework.container.Template load(String filePath) {
        try {
            Resource yamlSource = FileUtils.getFileResource((String)filePath);
            Template template = (Template)this.yaml.load(FileUtils.readToString((Resource)yamlSource));
            template.setReferenceResolver(this.referenceResolver);
            return template.build();
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to load YAML template for source '" + filePath + "'", (Throwable)e);
        }
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    public YamlTemplateLoader withReferenceResolver(ReferenceResolver referenceResolver) {
        this.setReferenceResolver(referenceResolver);
        return this;
    }
}

