/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaml;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.citrusframework.DefaultTestCaseRunner;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestSource;
import org.citrusframework.common.DefaultTestLoader;
import org.citrusframework.common.TestSourceAware;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.yaml.TestActions;
import org.citrusframework.yaml.YamlTestCase;
import org.citrusframework.yaml.actions.YamlTestActionBuilder;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;

public class YamlTestLoader
extends DefaultTestLoader
implements TestSourceAware {
    private TestSource source;
    private final Yaml yaml;

    public YamlTestLoader() {
        Constructor constructor = new Constructor(YamlTestCase.class, new LoaderOptions());
        constructor.setPropertyUtils(new PropertyUtils(){

            public Property getProperty(Class<?> type, String name, BeanAccess beanAccess) {
                if (name.indexOf(45) > -1) {
                    return super.getProperty(type, 1.cameCase(name), beanAccess);
                }
                return super.getProperty(type, name, beanAccess);
            }

            private static String cameCase(String input) {
                StringBuilder result = new StringBuilder();
                for (int i = 0; i < input.length(); ++i) {
                    if (input.charAt(i) == '-') {
                        if (i == input.length() - 1) continue;
                        result.append(String.valueOf(input.charAt(++i)).toUpperCase());
                        continue;
                    }
                    result.append(input.charAt(i));
                }
                return result.toString();
            }
        });
        try {
            Level original = Logger.getLogger("org.yaml.snakeyaml.introspector").getLevel();
            if (!Level.SEVERE.equals(original)) {
                Logger.getLogger("org.yaml.snakeyaml.introspector").setLevel(Level.SEVERE);
            }
        }
        catch (Exception original) {
            // empty catch block
        }
        Map<String, TestActionBuilder<?>> builders = YamlTestActionBuilder.lookup();
        if (!builders.isEmpty()) {
            TypeDescription actions = new TypeDescription(TestActions.class);
            for (Map.Entry<String, TestActionBuilder<?>> builder : builders.entrySet()) {
                actions.substituteProperty(builder.getKey(), builder.getValue().getClass(), "getAction", "setAction", new Class[]{TestActionBuilder.class});
            }
            constructor.addTypeDescription(actions);
        }
        this.yaml = new Yaml((BaseConstructor)constructor);
    }

    public YamlTestLoader(Class<?> testClass, String testName, String packageName) {
        this();
        this.testClass = testClass;
        this.testName = testName;
        this.packageName = packageName;
    }

    public void doLoad() {
        try {
            Resource yamlSource = this.getSource().getSourceFile();
            YamlTestCase tc = (YamlTestCase)this.yaml.load(FileUtils.readToString((Resource)yamlSource));
            this.testCase = tc.getTestCase();
            if (this.runner instanceof DefaultTestCaseRunner) {
                ((DefaultTestCaseRunner)this.runner).setTestCase(this.testCase);
            }
            this.testCase.getActionBuilders().stream().filter(action -> ReferenceResolverAware.class.isAssignableFrom(action.getClass())).map(ReferenceResolverAware.class::cast).forEach(action -> action.setReferenceResolver(this.context.getReferenceResolver()));
            this.configurer.forEach(handler -> handler.accept(this.testCase));
            this.citrus.run((TestAction)this.testCase, this.context);
            this.handler.forEach(handler -> handler.accept(this.testCase));
        }
        catch (IOException e) {
            throw this.context.handleError(this.testName, this.packageName, "Failed to load YAML test with name '" + this.testName + "'", (Exception)e);
        }
    }

    public TestSource getSource() {
        if (this.source != null) {
            return this.source;
        }
        String path = this.packageName.replace('.', '/');
        Object fileName = this.testName.endsWith(".yaml") ? this.testName : this.testName + ".yaml";
        return new TestSource("yaml", this.testName, "classpath:" + path + "/" + (String)fileName);
    }

    public void setSource(TestSource source) {
        this.source = source;
    }
}

