/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaml.actions;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.citrusframework.dsl.MessageSupport;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.DelegatingPathExpressionProcessor;
import org.citrusframework.message.MessageHeaderType;
import org.citrusframework.message.MessagePayloadBuilder;
import org.citrusframework.message.MessageProcessor;
import org.citrusframework.message.MessageType;
import org.citrusframework.message.ScriptPayloadBuilder;
import org.citrusframework.message.builder.MessageBuilderSupport;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.interceptor.BinaryMessageProcessor;
import org.citrusframework.validation.interceptor.GzipMessageProcessor;
import org.citrusframework.variable.VariableExtractor;
import org.citrusframework.yaml.actions.Message;

public final class MessageSupport {
    private MessageSupport() {
    }

    public static void configureMessage(MessageBuilderSupport.MessageActionBuilder<?, ?, ?> builder, Message message) {
        if (message.type != null) {
            if (StringUtils.hasText((String)message.type)) {
                if (message.type.equalsIgnoreCase(MessageType.GZIP.name())) {
                    builder.process((MessageProcessor)new GzipMessageProcessor());
                }
                if (message.type.equalsIgnoreCase(MessageType.BINARY.name())) {
                    builder.process((MessageProcessor)new BinaryMessageProcessor());
                }
            }
            builder.message().type(message.type);
        }
        if (message.body != null) {
            if (message.body.data != null) {
                builder.message().body(message.body.data.trim());
            }
            if (message.body.resource != null) {
                if (message.body.resource.charset != null) {
                    builder.message().body(FileUtils.getFileResource((String)(message.body.resource.file + FileUtils.FILE_PATH_CHARSET_PARAMETER + message.body.resource.charset)));
                } else {
                    builder.message().body(FileUtils.getFileResource((String)message.body.resource.file));
                }
            }
        }
        MessageSupport.configureScriptPayloadBuilder(builder, message);
        if (message.name != null) {
            builder.message().name(message.name);
        }
        HashMap<String, String> pathExpressions = new HashMap<String, String>();
        for (Message.Expression expression : message.getExpression()) {
            String pathExpression = expression.path;
            pathExpressions.put(pathExpression, expression.value);
        }
        if (!pathExpressions.isEmpty()) {
            builder.message().process((MessageProcessor)new DelegatingPathExpressionProcessor.Builder().expressions(pathExpressions).build());
        }
        if (message.dataDictionary != null) {
            builder.message().dictionary(message.dataDictionary);
        }
        for (Message.Header header : message.getHeaders()) {
            if (header.value != null) {
                String headerValue = StringUtils.hasText((String)header.type) ? MessageHeaderType.createTypedValue((String)header.type, (String)header.value) : header.value;
                builder.message().header(header.name, (Object)headerValue);
            }
            if (header.data != null) {
                if (header.name != null) {
                    builder.message().header(header.name, (Object)header.data);
                } else {
                    builder.message().header(header.data);
                }
            }
            if (header.resource == null) continue;
            if (header.resource.charset != null) {
                builder.message().header(FileUtils.getFileResource((String)(header.resource.file + FileUtils.FILE_PATH_CHARSET_PARAMETER + header.resource.charset)));
                continue;
            }
            builder.message().header(FileUtils.getFileResource((String)header.resource.file));
        }
    }

    private static void configureScriptPayloadBuilder(MessageBuilderSupport.MessageActionBuilder<?, ?, ?> builder, Message message) {
        if (message.body != null && message.body.builder != null) {
            String scriptType = Optional.ofNullable(message.body.builder.getType()).orElse("groovy");
            Optional scriptPayloadBuilder = ScriptPayloadBuilder.lookup((String)scriptType);
            if (scriptPayloadBuilder.isPresent()) {
                if (message.body.builder.getValue() != null) {
                    ((ScriptPayloadBuilder)scriptPayloadBuilder.get()).setScript(message.body.builder.getValue().trim());
                }
                if (message.body.builder.getFile() != null) {
                    if (message.body.builder.getCharset() != null) {
                        ((ScriptPayloadBuilder)scriptPayloadBuilder.get()).setFile(message.body.builder.getFile(), message.body.builder.getCharset());
                    } else {
                        ((ScriptPayloadBuilder)scriptPayloadBuilder.get()).setFile(message.body.builder.getFile());
                    }
                }
                builder.message().body((MessagePayloadBuilder)scriptPayloadBuilder.get());
            } else {
                throw new CitrusRuntimeException(String.format("Failed to resolve script payload builder for type '%s'", scriptType));
            }
        }
    }

    public static void configureExtract(MessageBuilderSupport.MessageActionBuilder<?, ?, ?> builder, Message.Extract value) {
        LinkedHashMap<String, String> expressions;
        if (!value.getHeader().isEmpty()) {
            expressions = new LinkedHashMap<String, String>();
            for (Message.Extract.Header header : value.getHeader()) {
                expressions.put(header.name, header.variable);
            }
            builder.message().extract((VariableExtractor.Builder)MessageSupport.MessageHeaderSupport.fromHeaders().expressions(expressions));
        }
        if (!value.getBody().isEmpty()) {
            expressions = new LinkedHashMap();
            for (Message.Extract.Expression expression : value.getBody()) {
                Object pathExpression = expression.path;
                if (expression.resultType != null) {
                    pathExpression = expression.resultType + ":" + (String)pathExpression;
                }
                expressions.put((String)pathExpression, expression.variable);
            }
            builder.message().extract((VariableExtractor.Builder)MessageSupport.MessageBodySupport.fromBody().expressions(expressions));
        }
    }
}

