/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaml.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestActor;
import org.citrusframework.actions.ReceiveMessageAction;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.context.DefaultMessageValidationContext;
import org.citrusframework.validation.context.HeaderValidationContext;
import org.citrusframework.validation.context.MessageValidationContext;
import org.citrusframework.validation.context.ValidationContext;
import org.citrusframework.validation.json.JsonPathMessageValidationContext;
import org.citrusframework.validation.script.ScriptValidationContext;
import org.citrusframework.validation.xml.XmlMessageValidationContext;
import org.citrusframework.yaml.actions.Message;
import org.citrusframework.yaml.actions.MessageSupport;
import org.citrusframework.yaml.actions.script.ScriptDefinitionType;

public class Receive
implements TestActionBuilder<ReceiveMessageAction>,
ReferenceResolverAware {
    private final ReceiveMessageAction.ReceiveMessageActionBuilder<?, ?, ?> builder;
    private String actor;
    private ReferenceResolver referenceResolver;
    private final List<String> validators = new ArrayList<String>();
    private MessageValidationContext.Builder<?, ?> messageValidationContext;
    protected Message message;
    protected List<Ignore> ignore;
    protected List<Validate> validate;
    protected List<Namespace> namespace;

    public Receive() {
        this((ReceiveMessageAction.ReceiveMessageActionBuilder<?, ?, ?>)new ReceiveMessageAction.Builder());
    }

    public Receive(ReceiveMessageAction.ReceiveMessageActionBuilder<?, ?, ?> builder) {
        this.builder = builder;
    }

    public void setDescription(String value) {
        this.builder.description(value);
    }

    public List<Ignore> getIgnore() {
        if (this.ignore == null) {
            this.ignore = new ArrayList<Ignore>();
        }
        return this.ignore;
    }

    public void setIgnore(List<Ignore> ignore) {
        this.ignore = ignore;
    }

    public List<Validate> getValidate() {
        if (this.validate == null) {
            this.validate = new ArrayList<Validate>();
        }
        return this.validate;
    }

    public void setValidate(List<Validate> validate) {
        this.validate = validate;
    }

    public List<Namespace> getNamespace() {
        if (this.namespace == null) {
            this.namespace = new ArrayList<Namespace>();
        }
        return this.namespace;
    }

    public void setNamespace(List<Namespace> namespace) {
        this.namespace = namespace;
    }

    public void setValidator(String validator) {
        if (StringUtils.hasText((String)validator)) {
            this.validators.add(validator);
        }
    }

    public void setValidators(String messageValidatorExpression) {
        if (StringUtils.hasText((String)messageValidatorExpression)) {
            Stream.of(messageValidatorExpression.split(",")).map(String::trim).forEach(this.validators::add);
        }
    }

    public void setHeaderValidator(String headerValidator) {
        if (StringUtils.hasText((String)headerValidator)) {
            this.builder.getHeaderValidationContext().validator(headerValidator);
        }
    }

    public void setHeaderValidators(String headerValidatorExpression) {
        if (StringUtils.hasText((String)headerValidatorExpression)) {
            Stream.of(headerValidatorExpression.split(",")).map(String::trim).forEach(arg_0 -> ((HeaderValidationContext.Builder)this.builder.getHeaderValidationContext()).validator(arg_0));
        }
    }

    public void setMessage(Message message) {
        this.message = message;
        MessageSupport.configureMessage(this.builder, message);
    }

    private void addScriptValidationContext() {
        ScriptValidationContext.Builder context = null;
        for (Validate validateElement : this.getValidate()) {
            ScriptDefinitionType scriptElement = validateElement.getScript();
            if (scriptElement == null) continue;
            if (context != null) {
                throw new CitrusRuntimeException("Found multiple validation script definitions - only supporting a single validation script for message validation");
            }
            String type = scriptElement.getType();
            context = new ScriptValidationContext.Builder().scriptType(type);
            String filePath = scriptElement.getFile();
            if (StringUtils.hasText((String)filePath)) {
                context.scriptResource(filePath);
                if (scriptElement.getCharset() != null) {
                    context.scriptResourceCharset(scriptElement.getCharset());
                }
            } else if (scriptElement.getValue() != null) {
                context.script(scriptElement.getValue().trim());
            }
            this.builder.validate((ValidationContext.Builder)context);
        }
    }

    private void addJsonValidationContext() {
        HashMap<String, Object> validateJsonPathExpressions = new HashMap<String, Object>();
        for (Validate validateElement : this.getValidate()) {
            this.extractJsonPathValidateExpressions(validateElement, validateJsonPathExpressions);
        }
        if (!validateJsonPathExpressions.isEmpty()) {
            JsonPathMessageValidationContext.Builder jsonPathContext = new JsonPathMessageValidationContext.Builder();
            jsonPathContext.expressions(validateJsonPathExpressions);
            this.builder.validate((ValidationContext.Builder)jsonPathContext);
        }
    }

    private void extractJsonPathValidateExpressions(Validate validateElement, Map<String, Object> validateJsonPathExpressions) {
        String pathExpression = validateElement.path;
        if (JsonPathMessageValidationContext.isJsonPathExpression((String)pathExpression)) {
            validateJsonPathExpressions.put(pathExpression, validateElement.value);
        }
        for (Validate.JsonPath jsonPathElement : validateElement.getJsonPath()) {
            String expression = jsonPathElement.expression;
            if (!StringUtils.hasText((String)expression)) continue;
            validateJsonPathExpressions.put(expression, jsonPathElement.value);
        }
    }

    private void addMessageValidationContext() {
        this.getIgnore().stream().map(Ignore::getPath).forEach(ignorePath -> this.getMessageValidationContext().ignore(ignorePath));
        if (this.message != null) {
            if (this.message.schema != null || this.message.schemaRepository != null) {
                this.getMessageValidationContext().schemaValidation(this.message.isSchemaValidation().booleanValue()).schema(this.message.schema).schemaRepository(this.message.schemaRepository);
            } else if (this.message.isSchemaValidation() != null && !this.message.isSchemaValidation().booleanValue()) {
                this.getMessageValidationContext().schemaValidation(this.message.isSchemaValidation().booleanValue());
            }
        }
    }

    private MessageValidationContext.Builder<?, ?> getMessageValidationContext() {
        if (this.messageValidationContext == null) {
            this.messageValidationContext = new DefaultMessageValidationContext.Builder();
        }
        return this.messageValidationContext;
    }

    private void addXmlValidationContext() {
        HashMap<String, String> validateNamespaces = new HashMap<String, String>();
        for (Validate validate : this.getValidate()) {
            for (Validate.Namespace namespaceElement : validate.getNamespace()) {
                validateNamespaces.put(namespaceElement.prefix, namespaceElement.value);
            }
        }
        if (!validateNamespaces.isEmpty()) {
            this.getXmlValidationContext().namespaces(validateNamespaces);
        }
        HashMap<String, String> namespaces = new HashMap<String, String>();
        for (Namespace namespace : this.getNamespace()) {
            namespaces.put(namespace.prefix, namespace.value);
        }
        if (!namespaces.isEmpty()) {
            this.getXmlValidationContext().namespaceContext(namespaces);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Validate validateElement : this.getValidate()) {
            this.extractXPathValidateExpressions(validateElement, hashMap);
        }
        if (!hashMap.isEmpty()) {
            this.messageValidationContext = this.getXmlValidationContext().xpath().expressions(hashMap);
        }
    }

    private XmlMessageValidationContext.Builder getXmlValidationContext() {
        if (this.messageValidationContext == null) {
            XmlMessageValidationContext.Builder builder;
            this.messageValidationContext = builder = new XmlMessageValidationContext.Builder();
            return builder;
        }
        XmlMessageValidationContext.Builder builder = this.messageValidationContext;
        if (builder instanceof XmlMessageValidationContext.Builder) {
            XmlMessageValidationContext.Builder xmlValidationContext = builder;
            return xmlValidationContext;
        }
        this.messageValidationContext = builder = XmlMessageValidationContext.Builder.adapt(this.messageValidationContext);
        return builder;
    }

    private void extractXPathValidateExpressions(Validate validateElement, Map<String, Object> validateXpathExpressions) {
        Object pathExpression = validateElement.path;
        if (StringUtils.hasText((String)pathExpression) && !JsonPathMessageValidationContext.isJsonPathExpression((String)pathExpression)) {
            if (validateElement.resultType != null) {
                pathExpression = validateElement.resultType + ":" + (String)pathExpression;
            }
            validateXpathExpressions.put((String)pathExpression, validateElement.value);
        }
        for (Validate.Xpath xpathElement : validateElement.getXpath()) {
            Object expression = xpathElement.expression;
            if (!StringUtils.hasText((String)expression)) continue;
            if (xpathElement.resultType != null) {
                expression = xpathElement.resultType + ":" + (String)expression;
            }
            validateXpathExpressions.put((String)expression, xpathElement.value);
        }
    }

    public void setExtract(Message.Extract value) {
        MessageSupport.configureExtract(this.builder, value);
    }

    public void setEndpoint(String value) {
        this.builder.endpoint(value);
    }

    public void setActor(String value) {
        this.actor = value;
    }

    public void setTimeout(Integer value) {
        this.builder.timeout((long)value.intValue());
    }

    public void setSelect(String value) {
        this.builder.selector(value);
    }

    public void setSelector(Selector selector) {
        if (selector.value != null) {
            this.builder.selector(selector.value);
        }
        if (selector.element != null) {
            HashMap<String, String> selectorElements = new HashMap<String, String>();
            for (Selector.Element element : selector.element) {
                selectorElements.put(element.name, element.value);
            }
            this.builder.selector(selectorElements);
        }
    }

    public ReceiveMessageAction build() {
        if (this.referenceResolver != null && this.actor != null) {
            this.builder.actor((TestActor)this.referenceResolver.resolve(this.actor, TestActor.class));
        }
        this.validators.forEach(arg_0 -> this.builder.validator(arg_0));
        this.addXmlValidationContext();
        this.addJsonValidationContext();
        this.addMessageValidationContext();
        this.addScriptValidationContext();
        if (this.messageValidationContext != null) {
            this.builder.validate(this.messageValidationContext);
        }
        return this.doBuild();
    }

    protected ReceiveMessageAction doBuild() {
        return this.builder.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.builder.setReferenceResolver(referenceResolver);
        this.referenceResolver = referenceResolver;
    }

    public static class Validate {
        protected ScriptDefinitionType script;
        protected List<Xpath> xpath;
        protected List<JsonPath> jsonPath;
        protected List<Namespace> namespace;
        protected String path;
        protected String value;
        protected String resultType;

        public ScriptDefinitionType getScript() {
            return this.script;
        }

        public void setScript(ScriptDefinitionType value) {
            this.script = value;
        }

        public List<Xpath> getXpath() {
            if (this.xpath == null) {
                this.xpath = new ArrayList<Xpath>();
            }
            return this.xpath;
        }

        public void setXpath(List<Xpath> xpath) {
            this.xpath = xpath;
        }

        public List<JsonPath> getJsonPath() {
            if (this.jsonPath == null) {
                this.jsonPath = new ArrayList<JsonPath>();
            }
            return this.jsonPath;
        }

        public void setJsonPath(List<JsonPath> jsonPath) {
            this.jsonPath = jsonPath;
        }

        public List<Namespace> getNamespace() {
            if (this.namespace == null) {
                this.namespace = new ArrayList<Namespace>();
            }
            return this.namespace;
        }

        public void setNamespace(List<Namespace> namespace) {
            this.namespace = namespace;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String value) {
            this.path = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getResultType() {
            return this.resultType;
        }

        public void setResultType(String value) {
            this.resultType = value;
        }

        public static class Xpath {
            protected String expression;
            protected String value;
            protected String resultType;

            public String getExpression() {
                return this.expression;
            }

            public void setExpression(String value) {
                this.expression = value;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public String getResultType() {
                return this.resultType;
            }

            public void setResultType(String value) {
                this.resultType = value;
            }
        }

        public static class Namespace {
            protected String prefix;
            protected String value;

            public String getPrefix() {
                return this.prefix;
            }

            public void setPrefix(String value) {
                this.prefix = value;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }

        public static class JsonPath {
            protected String expression;
            protected String value;

            public String getExpression() {
                return this.expression;
            }

            public void setExpression(String value) {
                this.expression = value;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }

    public static class Namespace {
        protected String prefix;
        protected String value;

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String value) {
            this.prefix = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class Selector {
        protected List<Element> element;
        protected String value;

        public List<Element> getElement() {
            if (this.element == null) {
                this.element = new ArrayList<Element>();
            }
            return this.element;
        }

        public void setElement(List<Element> element) {
            this.element = element;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public static class Element {
            protected String name;
            protected String value;

            public String getName() {
                return this.name;
            }

            public void setName(String value) {
                this.name = value;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }

    public static class Ignore {
        protected String path;

        public String getPath() {
            return this.path;
        }

        public void setPath(String value) {
            this.path = value;
        }
    }
}

