/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaml.container;

import org.citrusframework.TestActionBuilder;
import org.citrusframework.condition.ActionCondition;
import org.citrusframework.condition.Condition;
import org.citrusframework.condition.FileCondition;
import org.citrusframework.condition.HttpCondition;
import org.citrusframework.condition.MessageCondition;
import org.citrusframework.container.Wait;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.util.StringUtils;
import org.citrusframework.yaml.TestActions;

public class WaitFor
implements TestActionBuilder<Wait>,
ReferenceResolverAware {
    private final Wait.Builder<Condition> builder = new Wait.Builder();
    private TestActionBuilder<?> action;
    private ReferenceResolver referenceResolver;

    public Wait build() {
        if (this.action != null) {
            if (this.action instanceof ReferenceResolverAware) {
                ((ReferenceResolverAware)this.action).setReferenceResolver(this.referenceResolver);
            }
            ActionCondition condition = new ActionCondition();
            condition.setAction(this.action.build());
            this.builder.condition((Condition)condition);
        }
        return this.builder.build();
    }

    public void setDescription(String value) {
        this.builder.description(value);
    }

    public void setAction(TestActions action) {
        this.action = action.get();
    }

    public void setMessage(Message message) {
        MessageCondition condition = new MessageCondition();
        condition.setMessageName(message.name);
        this.builder.condition((Condition)condition);
    }

    public void setFile(File file) {
        FileCondition condition = new FileCondition();
        condition.setFilePath(file.path);
        this.builder.condition((Condition)condition);
    }

    public void setHttp(Http http) {
        String timeout;
        String statusCode;
        HttpCondition condition = new HttpCondition();
        condition.setUrl(http.url);
        String method = http.method;
        if (StringUtils.hasText((String)method)) {
            condition.setMethod(method);
        }
        if (StringUtils.hasText((String)(statusCode = http.status))) {
            condition.setHttpResponseCode(statusCode);
        }
        if (StringUtils.hasText((String)(timeout = http.timeout))) {
            condition.setTimeout(timeout);
        }
        this.builder.condition((Condition)condition);
    }

    public void setTimeout(String milliseconds) {
        this.builder.milliseconds(milliseconds);
    }

    public void setInterval(String interval) {
        this.builder.interval(interval);
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    public static class Message {
        protected String name;

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            this.name = value;
        }
    }

    public static class File {
        protected String path;

        public String getPath() {
            return this.path;
        }

        public void setPath(String value) {
            this.path = value;
        }
    }

    public static class Http {
        protected String url;
        protected String method;
        protected String status;
        protected String timeout;

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String value) {
            this.url = value;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String value) {
            this.method = value;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String value) {
            this.status = value;
        }

        public String getTimeout() {
            return this.timeout;
        }

        public void setTimeout(String value) {
            this.timeout = value;
        }
    }
}

