/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.mvn.plugin;

import java.util.Arrays;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.citrusframework.docs.ExcelTestDocsGenerator;
import org.citrusframework.docs.HtmlTestDocsGenerator;
import org.citrusframework.mvn.plugin.AbstractCitrusMojo;
import org.citrusframework.mvn.plugin.config.docs.ExcelDocConfiguration;
import org.citrusframework.mvn.plugin.config.docs.HtmlDocConfiguration;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

@Mojo(name="create-docs")
public class CreateDocsMojo
extends AbstractCitrusMojo {
    @Parameter(property="citrus.skip.create.docs", defaultValue="false")
    protected boolean skipCreateDocs;
    @Component
    private Prompter prompter;
    private final ExcelTestDocsGenerator excelTestDocsGenerator;
    private final HtmlTestDocsGenerator htmlTestDocsGenerator;

    public CreateDocsMojo() {
        this(new ExcelTestDocsGenerator(), new HtmlTestDocsGenerator());
    }

    public CreateDocsMojo(ExcelTestDocsGenerator excelTestDocsGenerator, HtmlTestDocsGenerator htmlTestDocsGenerator) {
        this.excelTestDocsGenerator = excelTestDocsGenerator;
        this.htmlTestDocsGenerator = htmlTestDocsGenerator;
    }

    @Override
    public void doExecute() throws MojoExecutionException {
        if (this.skipCreateDocs) {
            return;
        }
        try {
            String mode = this.prompter.prompt("Choose documentation mode:", Arrays.asList("excel", "html"), "html");
            if (mode.equals("excel")) {
                this.createExcelDoc();
            } else if (mode.equals("html")) {
                this.createHtmlDoc();
            }
        }
        catch (PrompterException e) {
            this.getLog().info((Throwable)e);
        }
    }

    private void createHtmlDoc() throws PrompterException {
        HtmlDocConfiguration configuration = new HtmlDocConfiguration();
        String heading = this.prompter.prompt("Enter overview title:", configuration.getHeading());
        String columns = this.prompter.prompt("Enter number of columns in overview:", configuration.getColumns());
        String pageTitle = this.prompter.prompt("Enter page title:", configuration.getPageTitle());
        String outputFile = this.prompter.prompt("Enter output file name:", configuration.getOutputFile());
        String logo = this.prompter.prompt("Enter file path to logo:", configuration.getLogo());
        String confirm = this.prompter.prompt("Confirm HTML documentation: outputFile='target/" + outputFile + (outputFile.endsWith(".html") ? "" : ".html") + "'\n", Arrays.asList("y", "n"), "y");
        if (confirm.equalsIgnoreCase("n")) {
            return;
        }
        HtmlTestDocsGenerator generator = this.getHtmlTestDocsGenerator();
        generator.withOutputFile(outputFile + (outputFile.endsWith(".html") ? "" : ".html")).withPageTitle(pageTitle).withOverviewTitle(heading).withColumns(columns).useSrcDirectory(this.getTestSrcDirectory()).withLogo(logo);
        generator.generateDoc();
        this.getLog().info((CharSequence)("Successfully created HTML documentation: outputFile='target/" + outputFile + (outputFile.endsWith(".html") ? "" : ".html") + "'"));
    }

    private void createExcelDoc() throws PrompterException {
        ExcelDocConfiguration configuration = new ExcelDocConfiguration();
        String company = this.prompter.prompt("Enter company:", configuration.getCompany());
        String author = this.prompter.prompt("Enter author:", configuration.getAuthor());
        String pageTitle = this.prompter.prompt("Enter page title:", configuration.getPageTitle());
        String outputFile = this.prompter.prompt("Enter output file name:", configuration.getOutputFile());
        String headers = this.prompter.prompt("Enter custom headers:", configuration.getHeaders());
        String confirm = this.prompter.prompt("Confirm Excel documentation: outputFile='target/" + outputFile + (outputFile.endsWith(".xls") ? "" : ".xls") + "'\n", Arrays.asList("y", "n"), "y");
        if (confirm.equalsIgnoreCase("n")) {
            return;
        }
        ExcelTestDocsGenerator generator = this.getExcelTestDocsGenerator();
        generator.withOutputFile(outputFile + (outputFile.endsWith(".xls") ? "" : ".xls")).withPageTitle(pageTitle).withAuthor(author).withCompany(company).useSrcDirectory(this.getTestSrcDirectory()).withCustomHeaders(headers);
        generator.generateDoc();
        this.getLog().info((CharSequence)("Successfully created Excel documentation: outputFile='target/" + outputFile + (outputFile.endsWith(".xls") ? "" : ".xls") + "'"));
    }

    public HtmlTestDocsGenerator getHtmlTestDocsGenerator() {
        return Optional.ofNullable(this.htmlTestDocsGenerator).orElseGet(HtmlTestDocsGenerator::build);
    }

    public ExcelTestDocsGenerator getExcelTestDocsGenerator() {
        return Optional.ofNullable(this.excelTestDocsGenerator).orElseGet(ExcelTestDocsGenerator::build);
    }

    public void setPrompter(Prompter prompter) {
        this.prompter = prompter;
    }
}

