/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.mvn.plugin;

import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.citrusframework.generate.SwaggerTestGenerator;
import org.citrusframework.generate.TestGenerator;
import org.citrusframework.generate.WsdlTestGenerator;
import org.citrusframework.generate.XsdTestGenerator;
import org.citrusframework.generate.javadsl.JavaDslTestGenerator;
import org.citrusframework.generate.javadsl.SwaggerJavaTestGenerator;
import org.citrusframework.generate.javadsl.WsdlJavaTestGenerator;
import org.citrusframework.generate.javadsl.XsdJavaTestGenerator;
import org.citrusframework.generate.xml.SwaggerXmlTestGenerator;
import org.citrusframework.generate.xml.WsdlXmlTestGenerator;
import org.citrusframework.generate.xml.XmlTestGenerator;
import org.citrusframework.generate.xml.XsdXmlTestGenerator;
import org.citrusframework.mvn.plugin.AbstractCitrusMojo;
import org.citrusframework.mvn.plugin.config.tests.TestConfiguration;
import org.citrusframework.util.StringUtils;

@Mojo(name="generate-tests", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES)
public class GenerateTestMojo
extends AbstractCitrusMojo {
    @Parameter(property="citrus.skip.generate.test", defaultValue="false")
    protected boolean skipGenerateTest;
    @Parameter(property="citrus.build.directory", defaultValue="${project.build.directory}/generated/citrus")
    protected String buildDirectory = "target/generated/citrus";
    private final XmlTestGenerator xmlTestGenerator;
    private final XsdXmlTestGenerator xsdXmlTestGenerator;
    private final WsdlXmlTestGenerator wsdlXmlTestGenerator;
    private final SwaggerXmlTestGenerator swaggerXmlTestGenerator;
    private final JavaDslTestGenerator javaTestGenerator;
    private final XsdJavaTestGenerator xsdJavaTestGenerator;
    private final WsdlJavaTestGenerator wsdlJavaTestGenerator;
    private final SwaggerJavaTestGenerator swaggerJavaTestGenerator;

    public GenerateTestMojo() {
        this(new XmlTestGenerator(), new XsdXmlTestGenerator(), new WsdlXmlTestGenerator(), new SwaggerXmlTestGenerator(), new JavaDslTestGenerator(), new XsdJavaTestGenerator(), new WsdlJavaTestGenerator(), new SwaggerJavaTestGenerator());
    }

    public GenerateTestMojo(XmlTestGenerator xmlTestGenerator, XsdXmlTestGenerator xsdXmlTestGenerator, WsdlXmlTestGenerator wsdlXmlTestGenerator, SwaggerXmlTestGenerator swaggerXmlTestGenerator, JavaDslTestGenerator javaTestGenerator, XsdJavaTestGenerator xsdJavaTestGenerator, WsdlJavaTestGenerator wsdlJavaTestGenerator, SwaggerJavaTestGenerator swaggerJavaTestGenerator) {
        this.xmlTestGenerator = xmlTestGenerator;
        this.xsdXmlTestGenerator = xsdXmlTestGenerator;
        this.wsdlXmlTestGenerator = wsdlXmlTestGenerator;
        this.swaggerXmlTestGenerator = swaggerXmlTestGenerator;
        this.javaTestGenerator = javaTestGenerator;
        this.xsdJavaTestGenerator = xsdJavaTestGenerator;
        this.wsdlJavaTestGenerator = wsdlJavaTestGenerator;
        this.swaggerJavaTestGenerator = swaggerJavaTestGenerator;
    }

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.skipGenerateTest) {
            return;
        }
        for (TestConfiguration test : this.getTests()) {
            XsdTestGenerator generator;
            if (test.getXsd() != null) {
                generator = this.getXsdTestGenerator();
                generator.withFramework(this.getFramework()).withName(test.getName()).withAuthor(test.getAuthor()).withDescription(test.getDescription()).usePackage(test.getPackageName()).useSrcDirectory(this.buildDirectory);
                generator.withDisabled(test.isDisabled());
                generator.withMode(TestGenerator.GeneratorMode.valueOf((String)test.getXsd().getMode()));
                generator.withXsd(test.getXsd().getFile());
                generator.withRequestMessage(test.getXsd().getRequest());
                generator.withResponseMessage(test.getXsd().getResponse());
                if (test.getXsd().getMappings() != null) {
                    generator.withInboundMappings(test.getXsd().getMappings().getInbound());
                    generator.withOutboundMappings(test.getXsd().getMappings().getOutbound());
                    generator.withInboundMappingFile(test.getXsd().getMappings().getInboundFile());
                    generator.withOutboundMappingFile(test.getXsd().getMappings().getOutboundFile());
                }
                generator.withEndpoint(test.getEndpoint());
                generator.withNameSuffix(test.getSuffix());
                generator.create();
                continue;
            }
            if (test.getWsdl() != null) {
                generator = this.getWsdlTestGenerator();
                generator.withFramework(this.getFramework()).withName(test.getName()).withAuthor(test.getAuthor()).withDescription(test.getDescription()).usePackage(test.getPackageName()).useSrcDirectory(this.buildDirectory);
                generator.withDisabled(test.isDisabled());
                generator.withMode(TestGenerator.GeneratorMode.valueOf((String)test.getWsdl().getMode()));
                generator.withWsdl(test.getWsdl().getFile());
                generator.withOperation(test.getWsdl().getOperation());
                if (test.getWsdl().getMappings() != null) {
                    generator.withInboundMappings(test.getWsdl().getMappings().getInbound());
                    generator.withOutboundMappings(test.getWsdl().getMappings().getOutbound());
                    generator.withInboundMappingFile(test.getWsdl().getMappings().getInboundFile());
                    generator.withOutboundMappingFile(test.getWsdl().getMappings().getOutboundFile());
                }
                generator.withEndpoint(test.getEndpoint());
                generator.withNameSuffix(test.getSuffix());
                generator.create();
                continue;
            }
            if (test.getSwagger() != null) {
                generator = this.getSwaggerTestGenerator();
                generator.withFramework(this.getFramework()).withName(test.getName()).withAuthor(test.getAuthor()).withDescription(test.getDescription()).usePackage(test.getPackageName()).useSrcDirectory(this.buildDirectory);
                generator.withDisabled(test.isDisabled());
                generator.withMode(TestGenerator.GeneratorMode.valueOf((String)test.getSwagger().getMode()));
                generator.withSpec(test.getSwagger().getFile());
                generator.withOperation(test.getSwagger().getOperation());
                if (test.getSwagger().getMappings() != null) {
                    generator.withInboundMappings(test.getSwagger().getMappings().getInbound());
                    generator.withOutboundMappings(test.getSwagger().getMappings().getOutbound());
                    generator.withInboundMappingFile(test.getSwagger().getMappings().getInboundFile());
                    generator.withOutboundMappingFile(test.getSwagger().getMappings().getOutboundFile());
                }
                generator.withEndpoint(test.getEndpoint());
                generator.withNameSuffix(test.getSuffix());
                generator.create();
                continue;
            }
            if (!StringUtils.hasText((String)test.getName())) {
                throw new MojoExecutionException("Please provide proper test name! Test name must not be empty starting with uppercase letter!");
            }
            if (this.getType().equals("java")) {
                generator = (JavaDslTestGenerator)this.getJavaTestGenerator().withDisabled(test.isDisabled()).withFramework(this.getFramework()).withName(test.getName()).withAuthor(test.getAuthor()).withDescription(test.getDescription()).usePackage(test.getPackageName()).useSrcDirectory(this.buildDirectory);
                generator.create();
            } else {
                generator = (XmlTestGenerator)this.getXmlTestGenerator().withDisabled(test.isDisabled()).withFramework(this.getFramework()).withName(test.getName()).withAuthor(test.getAuthor()).withDescription(test.getDescription()).usePackage(test.getPackageName()).useSrcDirectory(this.buildDirectory);
                generator.create();
            }
            this.getLog().info((CharSequence)("Successfully created new test case " + test.getPackageName() + "." + test.getName()));
        }
    }

    public XmlTestGenerator getXmlTestGenerator() {
        return Optional.ofNullable(this.xmlTestGenerator).orElseGet(XmlTestGenerator::new);
    }

    public JavaDslTestGenerator getJavaTestGenerator() {
        return Optional.ofNullable(this.javaTestGenerator).orElseGet(JavaDslTestGenerator::new);
    }

    public SwaggerTestGenerator getSwaggerTestGenerator() {
        if (this.getType().equals("java")) {
            return (SwaggerTestGenerator)Optional.ofNullable(this.swaggerJavaTestGenerator).orElseGet(SwaggerJavaTestGenerator::new);
        }
        return (SwaggerTestGenerator)Optional.ofNullable(this.swaggerXmlTestGenerator).orElseGet(SwaggerXmlTestGenerator::new);
    }

    public WsdlTestGenerator getWsdlTestGenerator() {
        if (this.getType().equals("java")) {
            return (WsdlTestGenerator)Optional.ofNullable(this.wsdlJavaTestGenerator).orElseGet(WsdlJavaTestGenerator::new);
        }
        return (WsdlTestGenerator)Optional.ofNullable(this.wsdlXmlTestGenerator).orElseGet(WsdlXmlTestGenerator::new);
    }

    public XsdTestGenerator getXsdTestGenerator() {
        if (this.getType().equals("java")) {
            return (XsdTestGenerator)Optional.ofNullable(this.xsdJavaTestGenerator).orElseGet(XsdJavaTestGenerator::new);
        }
        return (XsdTestGenerator)Optional.ofNullable(this.xsdXmlTestGenerator).orElseGet(XsdXmlTestGenerator::new);
    }
}

