/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk;

import java.util.Optional;
import org.citrusframework.yaks.YaksClusterType;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.kubernetes.KubernetesSettings;

public final class CamelKSettings {
    private static final String CAMELK_PROPERTY_PREFIX = "yaks.camelk.";
    private static final String CAMELK_ENV_PREFIX = "YAKS_CAMELK_";
    public static final String V1 = "v1";
    public static final String V1ALPHA1 = "v1alpha1";
    private static final String MAX_ATTEMPTS_PROPERTY = "yaks.camelk.max.attempts";
    private static final String MAX_ATTEMPTS_ENV = "YAKS_CAMELK_MAX_ATTEMPTS";
    private static final String MAX_ATTEMPTS_DEFAULT = String.valueOf(KubernetesSettings.getMaxAttempts());
    private static final String DELAY_BETWEEN_ATTEMPTS_PROPERTY = "yaks.camelk.delay.between.attempts";
    private static final String DELAY_BETWEEN_ATTEMPTS_ENV = "YAKS_CAMELK_DELAY_BETWEEN_ATTEMPTS";
    private static final String DELAY_BETWEEN_ATTEMPTS_DEFAULT = String.valueOf(KubernetesSettings.getDelayBetweenAttempts());
    private static final String NAMESPACE_PROPERTY = "yaks.camelk.namespace";
    private static final String NAMESPACE_ENV = "YAKS_CAMELK_NAMESPACE";
    private static final String OPERATOR_NAMESPACE_PROPERTY = "yaks.camelk.operator.namespace";
    private static final String OPERATOR_NAMESPACE_ENV = "YAKS_CAMELK_OPERATOR_NAMESPACE";
    private static final String OPERATOR_NAMESPACE_DEFAULT = "camel-system";
    private static final String API_VERSION_PROPERTY = "yaks.camelk.api.version";
    private static final String API_VERSION_ENV = "YAKS_CAMELK_API_VERSION";
    public static final String API_VERSION_DEFAULT = "v1";
    private static final String AUTO_REMOVE_RESOURCES_PROPERTY = "yaks.camelk.auto.remove.resources";
    private static final String AUTO_REMOVE_RESOURCES_ENV = "YAKS_CAMELK_AUTO_REMOVE_RESOURCES";
    private static final String AUTO_REMOVE_RESOURCES_DEFAULT = "true";
    private static final String SUPPORT_VARIABLES_IN_SOURCES_PROPERTY = "yaks.camelk.support.variables.in.sources";
    private static final String SUPPORT_VARIABLES_IN_SOURCES_ENV = "YAKS_CAMELK_SUPPORT_VARIABLES_IN_SOURCES";
    private static final String SUPPORT_VARIABLES_IN_SOURCES_DEFAULT = "true";
    private static final String PRINT_POD_LOGS_PROPERTY = "yaks.camelk.print.pod.logs";
    private static final String PRINT_POD_LOGS_ENV = "YAKS_CAMELK_PRINT_POD_LOGS";
    private static final String PRINT_POD_LOGS_DEFAULT = String.valueOf(KubernetesSettings.isPrintPodLogs());
    public static final String INTEGRATION_LABEL = "camel.apache.org/integration";

    private CamelKSettings() {
    }

    public static String getApiVersion() {
        return System.getProperty(API_VERSION_PROPERTY, System.getenv(API_VERSION_ENV) != null ? System.getenv(API_VERSION_ENV) : "v1");
    }

    public static int getMaxAttempts() {
        return Integer.parseInt(System.getProperty(MAX_ATTEMPTS_PROPERTY, System.getenv(MAX_ATTEMPTS_ENV) != null ? System.getenv(MAX_ATTEMPTS_ENV) : MAX_ATTEMPTS_DEFAULT));
    }

    public static long getDelayBetweenAttempts() {
        return Long.parseLong(System.getProperty(DELAY_BETWEEN_ATTEMPTS_PROPERTY, System.getenv(DELAY_BETWEEN_ATTEMPTS_ENV) != null ? System.getenv(DELAY_BETWEEN_ATTEMPTS_ENV) : DELAY_BETWEEN_ATTEMPTS_DEFAULT));
    }

    public static String getNamespace() {
        return System.getProperty(NAMESPACE_PROPERTY, System.getenv(NAMESPACE_ENV) != null ? System.getenv(NAMESPACE_ENV) : YaksSettings.getDefaultNamespace());
    }

    public static String getOperatorNamespace() {
        return Optional.ofNullable(System.getProperty(OPERATOR_NAMESPACE_PROPERTY, System.getenv(OPERATOR_NAMESPACE_ENV))).orElseGet(() -> YaksSettings.getClusterType().equals((Object)YaksClusterType.KUBERNETES) ? OPERATOR_NAMESPACE_DEFAULT : YaksSettings.getOperatorNamespace());
    }

    public static boolean isAutoRemoveResources() {
        return Boolean.parseBoolean(System.getProperty(AUTO_REMOVE_RESOURCES_PROPERTY, System.getenv(AUTO_REMOVE_RESOURCES_ENV) != null ? System.getenv(AUTO_REMOVE_RESOURCES_ENV) : "true"));
    }

    public static boolean isSupportVariablesInSources() {
        return Boolean.parseBoolean(System.getProperty(SUPPORT_VARIABLES_IN_SOURCES_PROPERTY, System.getenv(SUPPORT_VARIABLES_IN_SOURCES_ENV) != null ? System.getenv(SUPPORT_VARIABLES_IN_SOURCES_ENV) : "true"));
    }

    public static boolean isPrintPodLogs() {
        return Boolean.parseBoolean(System.getProperty(PRINT_POD_LOGS_PROPERTY, System.getenv(PRINT_POD_LOGS_ENV) != null ? System.getenv(PRINT_POD_LOGS_ENV) : PRINT_POD_LOGS_DEFAULT));
    }
}

