/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk;

import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.HashMap;
import java.util.Map;
import org.citrusframework.Citrus;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.actions.CreateVariablesAction;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.container.FinallySequence;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.citrusframework.yaks.camelk.CamelKSettings;
import org.citrusframework.yaks.camelk.KameletSettings;
import org.citrusframework.yaks.camelk.VariableNames;
import org.citrusframework.yaks.camelk.actions.CamelKActionBuilder;
import org.citrusframework.yaks.camelk.actions.kamelet.CreateKameletAction;
import org.citrusframework.yaks.camelk.actions.kamelet.CreatePipeAction;
import org.citrusframework.yaks.camelk.actions.kamelet.VerifyKameletAction;
import org.citrusframework.yaks.camelk.actions.kamelet.VerifyPipeAction;
import org.citrusframework.yaks.camelk.model.Kamelet;
import org.citrusframework.yaks.camelk.model.KameletSpec;
import org.citrusframework.yaks.camelk.model.Pipe;
import org.citrusframework.yaks.camelk.model.PipeSpec;
import org.citrusframework.yaks.kafka.KafkaSettings;
import org.citrusframework.yaks.knative.KnativeSettings;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;
import org.citrusframework.yaks.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class KameletSteps {
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusFramework
    private Citrus citrus;
    @CitrusResource
    private TestContext context;
    private KubernetesClient k8sClient;
    private String kameletApiVersion = KameletSettings.getKameletApiVersion();
    private Kamelet.Builder kamelet;
    private KameletSpec.Definition definition;
    private PipeSpec.Endpoint source;
    private PipeSpec.Endpoint sink;
    private Map<String, Object> sourceProperties;
    private Map<String, Object> sinkProperties;
    private String namespace = KameletSettings.getNamespace();
    private boolean autoRemoveResources = CamelKSettings.isAutoRemoveResources();
    private boolean supportVariablesInSources = CamelKSettings.isSupportVariablesInSources();

    @Before
    public void before(Scenario scenario) {
        if (this.k8sClient == null) {
            this.k8sClient = KubernetesSupport.getKubernetesClient((Citrus)this.citrus);
        }
        this.initializeKameletBuilder();
        this.initializePipeBuilder();
    }

    @Given(value="^Disable auto removal of Kamelet resources$")
    public void disableAutoRemove() {
        this.autoRemoveResources = false;
    }

    @Given(value="^Enable auto removal of Kamelet resources$")
    public void enableAutoRemove() {
        this.autoRemoveResources = true;
    }

    @Given(value="^Disable variable support in Kamelet sources$")
    public void disableVariableSupport() {
        this.supportVariablesInSources = false;
    }

    @Given(value="^Enable variable support in Kamelet sources$")
    public void enableVariableSupport() {
        this.supportVariablesInSources = true;
    }

    @Given(value="^Kamelet API version (v1|v1alpha1)$")
    public void setKameletApiVersion(String apiVersion) {
        this.kameletApiVersion = apiVersion;
        this.runner.run((TestActionBuilder)CreateVariablesAction.Builder.createVariable((String)VariableNames.KAMELET_API_VERSION.value(), (String)apiVersion));
    }

    @Given(value="^Kamelet namespace ([^\\s]+)$")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
        this.runner.run((TestActionBuilder)CreateVariablesAction.Builder.createVariable((String)VariableNames.KAMELET_NAMESPACE.value(), (String)namespace));
    }

    @Given(value="^Kamelet dataType (in|out|error)(?:=| is )\"(.+)\"$")
    public void addType(String slot, String format) {
        if (format.contains(":")) {
            String[] schemeAndFormat = format.split(":");
            this.kamelet.addDataType(slot, schemeAndFormat[0], schemeAndFormat[1]);
        } else {
            this.kamelet.addDataType(slot, "camel", format);
        }
    }

    @Given(value="^Kamelet title \"(.+)\"$")
    public void setTitle(String title) {
        this.definition.setTitle(title);
    }

    @Given(value="^Kamelet source ([a-z0-9-]+).([a-z0-9-]+)$")
    public void setSource(String name, String language, String content) {
        this.kamelet.source(name, language, content);
    }

    @Given(value="^Kamelet template")
    public void setFlow(String template) {
        this.kamelet.template(template);
    }

    @Given(value="^Kamelet property definition$")
    public void addPropertyDefinition(Map<String, Object> propertyConfiguration) {
        if (!propertyConfiguration.containsKey("name")) {
            throw new CitrusRuntimeException("Missing property name in configuration. Please add the property name to the property definition");
        }
        this.addPropertyDefinition(propertyConfiguration.get("name").toString(), propertyConfiguration);
    }

    @Given(value="^Kamelet property definition ([^\\s]+)$")
    public void addPropertyDefinition(String propertyName, Map<String, Object> propertyConfiguration) {
        String type = propertyConfiguration.getOrDefault("type", "string").toString();
        String title = propertyConfiguration.getOrDefault("title", StringUtils.capitalize((String)propertyName)).toString();
        Object defaultValue = propertyConfiguration.get("default");
        Object example = propertyConfiguration.get("example");
        String required = propertyConfiguration.getOrDefault("required", Boolean.FALSE).toString();
        if (Boolean.parseBoolean(required)) {
            this.definition.getRequired().add(propertyName);
        }
        this.definition.getProperties().put(propertyName, new KameletSpec.Definition.PropertyConfig(title, type, defaultValue, example));
    }

    @Given(value="^(?:Pipe|KameletBinding) source properties$")
    public void setPipeSourceProperties(Map<String, Object> properties) {
        this.sourceProperties.putAll(properties);
    }

    @Given(value="^(?:Pipe|KameletBinding) sink properties$")
    public void setPipeSinkProperties(Map<String, Object> properties) {
        this.sinkProperties.putAll(properties);
    }

    @Given(value="^bind Kamelet ([a-z0-9-]+) to uri ([^\\s]+)$")
    public void bindKameletToUri(String kameletName, String uri) {
        PipeSpec.Endpoint.ObjectReference sourceRef = new PipeSpec.Endpoint.ObjectReference("camel.apache.org/" + this.kameletApiVersion, "Kamelet", this.namespace, kameletName);
        this.source = new PipeSpec.Endpoint(sourceRef);
        this.sink = new PipeSpec.Endpoint(uri);
    }

    @Given(value="^bind Kamelet ([a-z0-9-]+) to Kafka topic ([^\\s]+)$")
    public void bindKameletToKafka(String kameletName, String topic) {
        PipeSpec.Endpoint.ObjectReference sourceRef = new PipeSpec.Endpoint.ObjectReference("camel.apache.org/" + this.kameletApiVersion, "Kamelet", this.namespace, kameletName);
        this.source = new PipeSpec.Endpoint(sourceRef);
        PipeSpec.Endpoint.ObjectReference sinkRef = new PipeSpec.Endpoint.ObjectReference("KafkaTopic", KafkaSettings.getNamespace(), topic);
        this.sink = new PipeSpec.Endpoint(sinkRef);
    }

    @Given(value="^bind Kamelet ([a-z0-9-]+) to Knative channel ([^\\s]+)$")
    public void bindKameletToKnativeChannel(String kameletName, String channel) {
        this.bindKameletToKnativeChannel(kameletName, channel, "InMemoryChannel");
    }

    @Given(value="^bind Kamelet ([a-z0-9-]+) to Knative channel ([^\\s]+) of kind ([^\\s]+)$")
    public void bindKameletToKnativeChannel(String kameletName, String channel, String channelKind) {
        PipeSpec.Endpoint.ObjectReference sourceRef = new PipeSpec.Endpoint.ObjectReference("camel.apache.org/" + this.kameletApiVersion, "Kamelet", this.namespace, kameletName);
        this.source = new PipeSpec.Endpoint(sourceRef);
        PipeSpec.Endpoint.ObjectReference sinkRef = new PipeSpec.Endpoint.ObjectReference(channelKind, KnativeSettings.getNamespace(), channel);
        this.sink = new PipeSpec.Endpoint(sinkRef);
    }

    @Given(value="^load Kamelet ([a-z0-9-]+).kamelet.yaml$")
    public void loadKameletFromFile(String fileName) {
        Resource resource = ResourceUtils.resolve((String)(fileName + ".kamelet.yaml"), (TestContext)this.context);
        this.runner.run((TestActionBuilder)((CreateKameletAction.Builder)((Object)CamelKActionBuilder.camelk().client(this.k8sClient).createKamelet(fileName).apiVersion(this.kameletApiVersion))).supportVariables(this.supportVariablesInSources).resource(resource));
        if (this.autoRemoveResources) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{CamelKActionBuilder.camelk().client(this.k8sClient).deleteKamelet(fileName).apiVersion(this.kameletApiVersion)}));
        }
    }

    @Given(value="^load (?:Pipe|KameletBinding) ([a-z0-9-]+).yaml$")
    public void loadPipeFromFile(String fileName) {
        Resource resource = ResourceUtils.resolve((String)(fileName + ".yaml"), (TestContext)this.context);
        this.runner.run((TestActionBuilder)CamelKActionBuilder.camelk().client(this.k8sClient).createPipe(fileName).resource(resource));
        if (this.autoRemoveResources) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{CamelKActionBuilder.camelk().client(this.k8sClient).deletePipe(fileName).apiVersion(this.kameletApiVersion)}));
        }
    }

    @Given(value="^(?:create|new) Kamelet ([a-z0-9-]+)$")
    public void createNewKamelet(String name) {
        this.kamelet.name(name);
        if (this.definition.getTitle() == null || this.definition.getTitle().isEmpty()) {
            this.definition.setTitle(StringUtils.capitalize((String)name));
        }
        this.kamelet.definition(this.definition);
        this.runner.run((TestActionBuilder)CamelKActionBuilder.camelk().client(this.k8sClient).createKamelet(name).supportVariables(this.supportVariablesInSources).fromBuilder(this.kamelet));
        this.initializeKameletBuilder();
        if (this.autoRemoveResources) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{CamelKActionBuilder.camelk().client(this.k8sClient).deleteKamelet(name).apiVersion(this.kameletApiVersion)}));
        }
    }

    @Deprecated
    @Given(value="^(?:create|new) Kamelet ([a-z0-9-]+) with flow")
    public void createNewKameletWithFlow(String name, String flow) {
        this.createNewKameletWithTemplate(name, flow);
    }

    @Given(value="^(?:create|new) Kamelet ([a-z0-9-]+) with template")
    public void createNewKameletWithTemplate(String name, String template) {
        this.kamelet.template(template);
        this.createNewKamelet(name);
    }

    @Given(value="^(?:create|new) (?:Pipe|KameletBinding) ([a-z0-9-]+)$")
    public void createNewPipe(String name) {
        Pipe.Builder pipe = new Pipe.Builder();
        pipe.name(name);
        this.source.getProperties().putAll(this.sourceProperties);
        this.sink.getProperties().putAll(this.sinkProperties);
        pipe.source(this.source);
        pipe.sink(this.sink);
        this.runner.run((TestActionBuilder)((CreatePipeAction.Builder)((Object)CamelKActionBuilder.camelk().client(this.k8sClient).createPipe(name).apiVersion(this.kameletApiVersion))).fromBuilder(pipe));
        this.initializePipeBuilder();
        if (this.autoRemoveResources) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{CamelKActionBuilder.camelk().client(this.k8sClient).deletePipe(name).apiVersion(this.kameletApiVersion)}));
        }
    }

    @Given(value="^delete Kamelet ([a-z0-9-]+)$")
    public void deleteKamelet(String name) {
        this.runner.run(CamelKActionBuilder.camelk().client(this.k8sClient).deleteKamelet(name).apiVersion(this.kameletApiVersion));
    }

    @Given(value="^delete (?:Pipe|KameletBinding) ([a-z0-9-]+)$")
    public void deletePipe(String name) {
        this.runner.run(CamelKActionBuilder.camelk().client(this.k8sClient).deletePipe(name).apiVersion(this.kameletApiVersion));
    }

    @Given(value="^Kamelet ([a-z0-9-]+) is available$")
    @Then(value="^Kamelet ([a-z0-9-]+) should be available$")
    public void kameletShouldBeAvailable(String name) {
        this.runner.run((TestActionBuilder)((VerifyKameletAction.Builder)((Object)CamelKActionBuilder.camelk().client(this.k8sClient).verifyKamelet(name).apiVersion(this.kameletApiVersion))).isAvailable());
    }

    @Given(value="^Kamelet ([a-z0-9-]+) is available in namespace ([a-z0-9-]+)$")
    @Then(value="^Kamelet ([a-z0-9-]+) should be available in namespace ([a-z0-9-]+)$")
    public void kameletShouldBeAvailable(String name, String namespace) {
        this.runner.run((TestActionBuilder)((VerifyKameletAction.Builder)((Object)((VerifyKameletAction.Builder)((Object)CamelKActionBuilder.camelk().client(this.k8sClient).verifyKamelet(name).apiVersion(this.kameletApiVersion))).namespace(namespace))).isAvailable());
    }

    @Given(value="^(?:Pipe|KameletBinding) ([a-z0-9-]+) is available$")
    @Then(value="^(?:Pipe|KameletBinding) ([a-z0-9-]+) should be available$")
    public void pipeShouldBeAvailable(String name) {
        this.runner.run((TestActionBuilder)((VerifyPipeAction.Builder)((Object)CamelKActionBuilder.camelk().client(this.k8sClient).verifyPipe(name).apiVersion(this.kameletApiVersion))).isAvailable());
    }

    private void initializeKameletBuilder() {
        this.kamelet = new Kamelet.Builder();
        this.definition = new KameletSpec.Definition();
    }

    private void initializePipeBuilder() {
        this.source = null;
        this.sink = null;
        this.sourceProperties = new HashMap<String, Object>();
        this.sinkProperties = new HashMap<String, Object>();
    }
}

