/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.actions;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.yaks.YaksClusterType;
import org.citrusframework.yaks.camelk.actions.CamelKAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCamelKAction
extends AbstractTestAction
implements CamelKAction {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final String namespace;
    private final KubernetesClient kubernetesClient;
    private final YaksClusterType clusterType;

    public AbstractCamelKAction(String name, Builder<?, ?> builder) {
        super("camel-k:" + name, builder);
        this.namespace = builder.namespace;
        this.kubernetesClient = builder.kubernetesClient;
        this.clusterType = builder.clusterType;
    }

    @Override
    public KubernetesClient getKubernetesClient() {
        return this.kubernetesClient;
    }

    @Override
    public String namespace(TestContext context) {
        if (this.namespace != null) {
            return context.replaceDynamicContentInString(this.namespace);
        }
        return CamelKAction.super.namespace(context);
    }

    @Override
    public YaksClusterType clusterType(TestContext context) {
        if (this.clusterType != null) {
            return this.clusterType;
        }
        return CamelKAction.super.clusterType(context);
    }

    public static abstract class Builder<T extends CamelKAction, B extends Builder<T, B>>
    extends AbstractTestActionBuilder<T, B> {
        private KubernetesClient kubernetesClient;
        private String namespace;
        private YaksClusterType clusterType;

        public B client(KubernetesClient kubernetesClient) {
            this.kubernetesClient = kubernetesClient;
            return (B)((Object)((Builder)this.self));
        }

        public B namespace(String namespace) {
            this.namespace = namespace;
            return (B)((Object)((Builder)this.self));
        }

        public B clusterType(YaksClusterType clusterType) {
            this.clusterType = clusterType;
            return (B)((Object)((Builder)this.self));
        }
    }
}

