/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.actions;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.yaks.camelk.actions.AbstractCamelKAction;
import org.citrusframework.yaks.camelk.actions.CamelKAction;
import org.citrusframework.yaks.camelk.actions.integration.CreateIntegrationAction;
import org.citrusframework.yaks.camelk.actions.integration.DeleteIntegrationAction;
import org.citrusframework.yaks.camelk.actions.integration.VerifyIntegrationAction;
import org.citrusframework.yaks.camelk.actions.kamelet.CreateKameletAction;
import org.citrusframework.yaks.camelk.actions.kamelet.CreatePipeAction;
import org.citrusframework.yaks.camelk.actions.kamelet.DeleteKameletAction;
import org.citrusframework.yaks.camelk.actions.kamelet.DeletePipeAction;
import org.citrusframework.yaks.camelk.actions.kamelet.VerifyKameletAction;
import org.citrusframework.yaks.camelk.actions.kamelet.VerifyPipeAction;
import org.springframework.util.Assert;

public class CamelKActionBuilder
implements TestActionBuilder.DelegatingTestActionBuilder<CamelKAction> {
    private KubernetesClient kubernetesClient;
    private AbstractCamelKAction.Builder<? extends CamelKAction, ?> delegate;

    public static CamelKActionBuilder camelk() {
        return new CamelKActionBuilder();
    }

    public CamelKActionBuilder client(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
        return this;
    }

    public CreateIntegrationAction.Builder createIntegration(String integrationName) {
        CreateIntegrationAction.Builder builder;
        this.delegate = builder = ((CreateIntegrationAction.Builder)((Object)new CreateIntegrationAction.Builder().client(this.kubernetesClient))).integration(integrationName);
        return builder;
    }

    public DeleteIntegrationAction.Builder deleteIntegration(String integrationName) {
        DeleteIntegrationAction.Builder builder;
        this.delegate = builder = ((DeleteIntegrationAction.Builder)((Object)new DeleteIntegrationAction.Builder().client(this.kubernetesClient))).integration(integrationName);
        return builder;
    }

    public CreateKameletAction.Builder createKamelet(String kameletName) {
        CreateKameletAction.Builder builder;
        this.delegate = builder = ((CreateKameletAction.Builder)((Object)new CreateKameletAction.Builder().client(this.kubernetesClient))).kamelet(kameletName);
        return builder;
    }

    public DeleteKameletAction.Builder deleteKamelet(String kameletName) {
        DeleteKameletAction.Builder builder;
        this.delegate = builder = ((DeleteKameletAction.Builder)((Object)new DeleteKameletAction.Builder().client(this.kubernetesClient))).kamelet(kameletName);
        return builder;
    }

    public CreatePipeAction.Builder createPipe(String pipeName) {
        CreatePipeAction.Builder builder;
        this.delegate = builder = ((CreatePipeAction.Builder)((Object)new CreatePipeAction.Builder().client(this.kubernetesClient))).pipe(pipeName);
        return builder;
    }

    public DeletePipeAction.Builder deletePipe(String pipeName) {
        DeletePipeAction.Builder builder;
        this.delegate = builder = ((DeletePipeAction.Builder)((Object)new DeletePipeAction.Builder().client(this.kubernetesClient))).pipe(pipeName);
        return builder;
    }

    public VerifyIntegrationAction.Builder verifyIntegration(String integrationName) {
        VerifyIntegrationAction.Builder builder;
        this.delegate = builder = ((VerifyIntegrationAction.Builder)((Object)new VerifyIntegrationAction.Builder().client(this.kubernetesClient))).integrationName(integrationName);
        return builder;
    }

    public VerifyKameletAction.Builder verifyKamelet(String kameletName) {
        VerifyKameletAction.Builder builder;
        this.delegate = builder = ((VerifyKameletAction.Builder)((Object)new VerifyKameletAction.Builder().client(this.kubernetesClient))).kameletName(kameletName);
        return builder;
    }

    public VerifyPipeAction.Builder verifyPipe(String pipeName) {
        VerifyPipeAction.Builder builder;
        this.delegate = builder = ((VerifyPipeAction.Builder)((Object)new VerifyPipeAction.Builder().client(this.kubernetesClient))).isAvailable(pipeName);
        return builder;
    }

    public CamelKAction build() {
        Assert.notNull(this.delegate, (String)"Missing delegate action to build");
        if (this.kubernetesClient != null) {
            this.delegate.client(this.kubernetesClient);
        }
        return (CamelKAction)this.delegate.build();
    }

    public TestActionBuilder<?> getDelegate() {
        return this.delegate;
    }
}

