/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.actions.integration;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Updatable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.variable.VariableUtils;
import org.citrusframework.yaks.YaksClusterType;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.camelk.actions.AbstractCamelKAction;
import org.citrusframework.yaks.camelk.jbang.CamelJBang;
import org.citrusframework.yaks.camelk.jbang.CamelJBangSettings;
import org.citrusframework.yaks.camelk.jbang.ProcessAndOutput;
import org.citrusframework.yaks.camelk.model.Integration;
import org.citrusframework.yaks.camelk.model.IntegrationList;
import org.citrusframework.yaks.camelk.model.IntegrationSpec;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;
import org.citrusframework.yaks.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateIntegrationAction
extends AbstractCamelKAction {
    private static final Logger LOG = LoggerFactory.getLogger(CreateIntegrationAction.class);
    private final String integrationName;
    private final String fileName;
    private final String source;
    private final List<String> dependencies;
    private final List<String> buildProperties;
    private final List<String> buildPropertyFiles;
    private final List<String> properties;
    private final List<String> propertyFiles;
    private final List<String> traits;
    private final Map<String, String> openApis;
    private final boolean supportVariables;

    public CreateIntegrationAction(Builder builder) {
        super("create-integration", builder);
        this.integrationName = builder.integrationName;
        this.fileName = builder.fileName;
        this.source = builder.source;
        this.dependencies = builder.dependencies;
        this.buildProperties = builder.buildProperties;
        this.buildPropertyFiles = builder.buildPropertyFiles;
        this.properties = builder.properties;
        this.propertyFiles = builder.propertyFiles;
        this.traits = builder.traits;
        this.openApis = builder.openApis;
        this.supportVariables = builder.supportVariables;
    }

    public void doExecute(TestContext context) {
        String name = context.replaceDynamicContentInString(this.integrationName);
        LOG.info(String.format("Creating Camel K integration '%s'", name));
        String resolvedSource = this.supportVariables ? context.replaceDynamicContentInString(this.source) : this.source;
        Integration.Builder integrationBuilder = new Integration.Builder().name(name).source(context.replaceDynamicContentInString(this.fileName), resolvedSource);
        List<String> resolvedDependencies = CreateIntegrationAction.resolveDependencies(resolvedSource, context.resolveDynamicValuesInList(this.dependencies));
        if (!resolvedDependencies.isEmpty()) {
            integrationBuilder.dependencies(resolvedDependencies);
        }
        this.addPropertyConfigurationSpec(integrationBuilder, context);
        this.addBuildPropertyConfigurationSpec(integrationBuilder, resolvedSource, context);
        this.addRuntimeConfigurationSpec(integrationBuilder, resolvedSource, context);
        this.addTraitSpec(integrationBuilder, resolvedSource, context);
        this.addOpenApiSpec(integrationBuilder, resolvedSource, context);
        Integration integration = integrationBuilder.build();
        if (YaksSettings.isLocal((YaksClusterType)this.clusterType(context))) {
            CreateIntegrationAction.createLocalIntegration(integration, integration.getMetadata().getName(), context);
        } else {
            CreateIntegrationAction.createIntegration(this.getKubernetesClient(), this.namespace(context), integration);
        }
        LOG.info(String.format("Successfully created Camel K integration '%s'", integration.getMetadata().getName()));
    }

    private static void createIntegration(KubernetesClient k8sClient, String namespace, Integration integration) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(KubernetesSupport.yaml().dumpAsMap((Object)integration));
        }
        ((io.fabric8.kubernetes.client.dsl.Resource)((NonNamespaceOperation)k8sClient.resources(Integration.class, IntegrationList.class).inNamespace(namespace)).resource((Object)integration)).createOr(Updatable::update);
    }

    private static void createLocalIntegration(Integration integration, String name, TestContext context) {
        try {
            Object integrationYaml = KubernetesSupport.yaml().dumpAsMap((Object)integration);
            if (LOG.isDebugEnabled()) {
                LOG.debug((String)integrationYaml);
            }
            integrationYaml = (String)integrationYaml + "#KameletBinding";
            Path workDir = CamelJBangSettings.getWorkDir();
            Files.createDirectories(workDir, new FileAttribute[0]);
            Path file = workDir.resolve(String.format("i-%s.yaml", name));
            Files.write(file, ((String)integrationYaml).getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            ProcessAndOutput pao = CamelJBang.camel().run(name, file, CreateIntegrationAction.camelRunArgs(integration));
            if (!pao.getProcess().isAlive()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(pao.getOutput());
                }
                throw new CitrusRuntimeException(String.format("Failed to create Camel K integration - exit code %s", pao.getProcess().exitValue()));
            }
            Long pid = pao.getCamelProcessId();
            context.setVariable(name + ":pid", (Object)pid);
            context.setVariable(name + ":process:" + pid, (Object)pao);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to create integration file", (Throwable)e);
        }
    }

    private static String[] camelRunArgs(Integration integration) {
        ArrayList<String> args = new ArrayList<String>();
        if (((IntegrationSpec)integration.getSpec()).getResources() != null) {
            List openApiResources = ((IntegrationSpec)integration.getSpec()).getResources().stream().filter(r -> "openapi".equals(r.getType())).collect(Collectors.toList());
            for (IntegrationSpec.Resource resource : openApiResources) {
                args.add("--open-api");
                args.add(resource.getName());
            }
        }
        return (String[])args.toArray(String[]::new);
    }

    private void addOpenApiSpec(Integration.Builder integrationBuilder, String source, TestContext context) {
        Pattern pattern = CreateIntegrationAction.getModelinePattern("open-api");
        Matcher depMatcher = pattern.matcher(source);
        while (depMatcher.find()) {
            String openApiSpecFile = depMatcher.group(1);
            try {
                integrationBuilder.openApi(openApiSpecFile, FileUtils.readToString((Resource)FileUtils.getFileResource((String)openApiSpecFile, (TestContext)context)));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException(String.format("Failed to load OpenAPI spec from file '%s'", openApiSpecFile), (Throwable)e);
            }
        }
        this.openApis.forEach((k, v) -> integrationBuilder.openApi((String)k, context.replaceDynamicContentInString(v)));
    }

    private void addTraitSpec(Integration.Builder integrationBuilder, String source, TestContext context) {
        HashMap<String, IntegrationSpec.TraitConfig> traitConfigMap = new HashMap<String, IntegrationSpec.TraitConfig>();
        if (this.traits != null && !this.traits.isEmpty()) {
            for (String t : context.resolveDynamicValuesInList(this.traits)) {
                this.addTraitSpec(t, traitConfigMap);
            }
        }
        Pattern pattern = CreateIntegrationAction.getModelinePattern("trait");
        Matcher depMatcher = pattern.matcher(source);
        while (depMatcher.find()) {
            this.addTraitSpec(depMatcher.group(1), traitConfigMap);
        }
        if (!traitConfigMap.isEmpty()) {
            integrationBuilder.traits(traitConfigMap);
        }
    }

    private void addTraitSpec(String traitExpression, Map<String, IntegrationSpec.TraitConfig> configMap) {
        String[] trait = traitExpression.split("\\.", 2);
        String[] traitConfig = trait[1].split("=", 2);
        String traitKey = traitConfig[0];
        Object traitValue = this.resolveTraitValue(traitKey, traitConfig[1].trim());
        if (configMap.containsKey(trait[0])) {
            IntegrationSpec.TraitConfig config = configMap.get(trait[0]);
            if (config.getConfiguration().containsKey(traitKey)) {
                Object existingValue = config.getConfiguration().get(traitKey);
                if (existingValue instanceof List) {
                    List values = (List)existingValue;
                    values.add(traitValue.toString());
                } else {
                    config.add(traitKey, Arrays.asList(existingValue.toString(), traitValue));
                }
            } else {
                config.add(traitKey, this.initializeTraitValue(traitValue));
            }
        } else {
            configMap.put(trait[0], new IntegrationSpec.TraitConfig(traitKey, this.initializeTraitValue(traitValue)));
        }
    }

    private Object initializeTraitValue(Object value) {
        if (value instanceof String && value.toString().startsWith("[") && value.toString().endsWith("]")) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(this.resolveTraitValue("", value.toString().substring(1, value.toString().length() - 1)).toString());
            return values;
        }
        return value;
    }

    private Object resolveTraitValue(String traitKey, String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return VariableUtils.cutOffDoubleQuotes((String)value);
        }
        if (value.startsWith("'") && value.endsWith("'")) {
            return VariableUtils.cutOffSingleQuotes((String)value);
        }
        if (traitKey.equalsIgnoreCase("enabled") || traitKey.equalsIgnoreCase("verbose")) {
            return Boolean.valueOf(value);
        }
        return value;
    }

    private void addPropertyConfigurationSpec(Integration.Builder integrationBuilder, TestContext context) {
        ArrayList<IntegrationSpec.Configuration> configurationList = new ArrayList<IntegrationSpec.Configuration>();
        if (this.properties != null && !this.properties.isEmpty()) {
            for (String p : context.resolveDynamicValuesInList(this.properties)) {
                if (CreateIntegrationAction.isValidPropertyFormat(p)) {
                    String[] property = p.split("=", 2);
                    configurationList.add(new IntegrationSpec.Configuration("property", this.createPropertySpec(property[0], property[1], context)));
                    continue;
                }
                throw new IllegalArgumentException("Property " + p + " does not match format key=value");
            }
        }
        if (this.propertyFiles != null && !this.propertyFiles.isEmpty()) {
            for (String pf : this.propertyFiles) {
                try {
                    Properties props = new Properties();
                    props.load(ResourceUtils.resolve((String)pf, (TestContext)context).getInputStream());
                    props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> configurationList.add(new IntegrationSpec.Configuration("property", this.createPropertySpec(key.toString(), value.toString(), context)))));
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to load property file", (Throwable)e);
                }
            }
        }
        if (!configurationList.isEmpty()) {
            integrationBuilder.configuration(configurationList);
        }
    }

    private void addBuildPropertyConfigurationSpec(Integration.Builder integrationBuilder, String source, TestContext context) {
        String traitName = "builder.properties";
        HashMap<String, IntegrationSpec.TraitConfig> traitConfigMap = new HashMap<String, IntegrationSpec.TraitConfig>();
        if (this.buildProperties != null && !this.buildProperties.isEmpty()) {
            for (String p : context.resolveDynamicValuesInList(this.buildProperties)) {
                if (CreateIntegrationAction.isValidPropertyFormat(p)) {
                    String[] property = p.split("=", 2);
                    this.addTraitSpec(String.format("%s=%s", "builder.properties", this.createPropertySpec(property[0], property[1], context)), traitConfigMap);
                    continue;
                }
                throw new IllegalArgumentException("Property " + p + " does not match format key=value");
            }
        }
        if (this.buildPropertyFiles != null && !this.buildPropertyFiles.isEmpty()) {
            for (String pf : this.buildPropertyFiles) {
                try {
                    Properties props = new Properties();
                    props.load(ResourceUtils.resolve((String)pf, (TestContext)context).getInputStream());
                    props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.addTraitSpec(String.format("%s=%s", "builder.properties", this.createPropertySpec(key.toString(), value.toString(), context)), traitConfigMap)));
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to load property file", (Throwable)e);
                }
            }
        }
        Pattern pattern = CreateIntegrationAction.getModelinePattern("build-property");
        Matcher depMatcher = pattern.matcher(source);
        while (depMatcher.find()) {
            this.addTraitSpec(String.format("%s=%s", "builder.properties", depMatcher.group(1)), traitConfigMap);
        }
        if (!traitConfigMap.isEmpty()) {
            integrationBuilder.traits(traitConfigMap);
        }
    }

    private void addRuntimeConfigurationSpec(Integration.Builder integrationBuilder, String source, TestContext context) {
        ArrayList<IntegrationSpec.Configuration> configurationList = new ArrayList<IntegrationSpec.Configuration>();
        Pattern pattern = CreateIntegrationAction.getModelinePattern("config");
        Matcher depMatcher = pattern.matcher(source);
        while (depMatcher.find()) {
            String[] config = depMatcher.group(1).split(":", 2);
            if (config.length == 2) {
                configurationList.add(new IntegrationSpec.Configuration(config[0], config[1]));
                continue;
            }
            configurationList.add(new IntegrationSpec.Configuration("property", depMatcher.group(1)));
        }
        if (!configurationList.isEmpty()) {
            integrationBuilder.configuration(configurationList);
        }
    }

    private String createPropertySpec(String key, String value, TestContext context) {
        return this.escapePropertyItem(key) + "=" + this.escapePropertyItem(context.replaceDynamicContentInString(value));
    }

    private String escapePropertyItem(String item) {
        return item.replaceAll(":", "\\:").replaceAll("=", "\\=");
    }

    private static boolean isValidPropertyFormat(String property) {
        String patternString = "[^\\s]+=.*";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(property);
        return matcher.matches();
    }

    private static List<String> resolveDependencies(String source, List<String> dependencies) {
        ArrayList<String> resolved = new ArrayList<String>(dependencies);
        Pattern pattern = CreateIntegrationAction.getModelinePattern("dependency");
        Matcher depMatcher = pattern.matcher(source);
        while (depMatcher.find()) {
            Object dependency = depMatcher.group(1);
            if (((String)dependency).startsWith("camel-quarkus-")) {
                dependency = "camel:" + ((String)dependency).substring("camel-quarkus-".length());
            } else if (((String)dependency).startsWith("camel-quarkus:")) {
                dependency = "camel:" + ((String)dependency).substring("camel-quarkus:".length());
            } else if (((String)dependency).startsWith("camel-")) {
                dependency = "camel:" + ((String)dependency).substring("camel-".length());
            }
            resolved.add((String)dependency);
        }
        return resolved;
    }

    private static Pattern getModelinePattern(String name) {
        return Pattern.compile(String.format("^// camel-k: ?%s=(.+)$", name), 8);
    }

    public static final class Builder
    extends AbstractCamelKAction.Builder<CreateIntegrationAction, Builder> {
        private String integrationName;
        private String fileName;
        private String source;
        private final List<String> dependencies = new ArrayList<String>();
        private final List<String> buildProperties = new ArrayList<String>();
        private final List<String> buildPropertyFiles = new ArrayList<String>();
        private final List<String> properties = new ArrayList<String>();
        private final List<String> propertyFiles = new ArrayList<String>();
        private final List<String> traits = new ArrayList<String>();
        private final Map<String, String> openApis = new LinkedHashMap<String, String>();
        private boolean supportVariables = true;

        public Builder integration(String integrationName) {
            this.integrationName = integrationName;
            if (this.fileName == null) {
                this.fileName = integrationName;
            }
            return this;
        }

        public Builder supportVariables(boolean supportVariables) {
            this.supportVariables = supportVariables;
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder source(String fileName, String source) {
            this.fileName = fileName;
            this.source = source;
            return this;
        }

        public Builder openApi(String fileName, String content) {
            this.openApis.put(fileName, content);
            return this;
        }

        public Builder dependencies(String dependencies) {
            if (dependencies != null && dependencies.length() > 0) {
                this.dependencies(Arrays.asList(dependencies.split(",")));
            }
            return this;
        }

        public Builder propertyFile(String propertyFile) {
            this.propertyFiles.add(propertyFile);
            return this;
        }

        public Builder propertyFiles(List<String> propertyFiles) {
            this.propertyFiles.addAll(propertyFiles);
            return this;
        }

        public Builder properties(String properties) {
            if (properties != null && properties.length() > 0) {
                this.properties(Arrays.asList(properties.split(",")));
            }
            return this;
        }

        public Builder properties(List<String> properties) {
            this.properties.addAll(properties);
            return this;
        }

        public Builder properties(Map<String, String> properties) {
            properties.forEach(this::property);
            return this;
        }

        public Builder buildPropertyFile(String propertyFile) {
            this.buildPropertyFiles.add(propertyFile);
            return this;
        }

        public Builder buildPropertyFiles(List<String> propertyFiles) {
            this.buildPropertyFiles.addAll(propertyFiles);
            return this;
        }

        public Builder buildProperties(String properties) {
            if (properties != null && properties.length() > 0) {
                this.buildProperties(Arrays.asList(properties.split(",")));
            }
            return this;
        }

        public Builder buildProperties(List<String> properties) {
            this.buildProperties.addAll(properties);
            return this;
        }

        public Builder buildProperties(Map<String, String> properties) {
            properties.forEach(this::buildProperty);
            return this;
        }

        public Builder dependencies(List<String> dependencies) {
            this.dependencies.addAll(dependencies);
            return this;
        }

        public Builder dependency(String dependency) {
            this.dependencies.add(dependency);
            return this;
        }

        public Builder property(String name, String value) {
            this.properties.add(name + "=" + value);
            return this;
        }

        public Builder buildProperty(String name, String value) {
            this.buildProperties.add(name + "=" + value);
            return this;
        }

        public Builder traits(String traits) {
            if (traits != null && traits.length() > 0) {
                this.traits(Arrays.asList(traits.split(",")));
            }
            return this;
        }

        public Builder traits(List<String> traits) {
            this.traits.addAll(traits);
            return this;
        }

        public Builder trait(String name, String key, Object value) {
            this.traits.add(String.format("%s.%s=%s", name, key, value));
            return this;
        }

        public CreateIntegrationAction build() {
            return new CreateIntegrationAction(this);
        }
    }
}

