/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.actions.integration;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.util.Map;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ActionTimeoutException;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.yaks.YaksClusterType;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.camelk.CamelKSettings;
import org.citrusframework.yaks.camelk.actions.AbstractCamelKAction;
import org.citrusframework.yaks.camelk.jbang.CamelJBang;
import org.citrusframework.yaks.camelk.jbang.ProcessAndOutput;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyIntegrationAction
extends AbstractCamelKAction {
    private static final Logger INTEGRATION_STATUS_LOG = LoggerFactory.getLogger((String)"INTEGRATION_STATUS");
    private static final Logger INTEGRATION_LOG = LoggerFactory.getLogger((String)"INTEGRATION_LOGS");
    private final String integrationName;
    private final String logMessage;
    private final int maxAttempts;
    private final long delayBetweenAttempts;
    private final String phase;
    private final boolean printLogs;

    public VerifyIntegrationAction(Builder builder) {
        super("verify-integration", builder);
        this.integrationName = builder.integrationName;
        this.phase = builder.phase;
        this.logMessage = builder.logMessage;
        this.maxAttempts = builder.maxAttempts;
        this.delayBetweenAttempts = builder.delayBetweenAttempts;
        this.printLogs = builder.printLogs;
    }

    public void doExecute(TestContext context) {
        String name = context.replaceDynamicContentInString(this.integrationName);
        this.LOG.info(String.format("Verify Camel K integration '%s'", name));
        if (YaksSettings.isLocal((YaksClusterType)this.clusterType(context))) {
            this.verifyLocalIntegration(name, context);
        } else {
            this.verifyIntegration(this.namespace(context), name, context);
        }
        this.LOG.info(String.format("Successfully verified Camel K integration '%s'", name));
    }

    private void verifyLocalIntegration(String integration, TestContext context) {
        Long pid = this.verifyLocalIntegrationStatus(integration, context.replaceDynamicContentInString(this.phase), context);
        if (this.logMessage != null) {
            this.verifyLocalIntegrationLogs(pid, integration, context.replaceDynamicContentInString(this.logMessage), context);
        }
    }

    private void verifyLocalIntegrationLogs(Long pid, String integration, String message, TestContext context) {
        if (this.printLogs) {
            INTEGRATION_LOG.info(String.format("Waiting for integration '%s' to log message", integration));
        }
        int offset = 0;
        ProcessAndOutput pao = (ProcessAndOutput)context.getVariable(integration + ":process:" + pid, ProcessAndOutput.class);
        for (int i = 0; i < this.maxAttempts; ++i) {
            String log = pao.getOutput();
            if (this.printLogs && offset < log.length()) {
                INTEGRATION_LOG.info(log.substring(offset));
                offset = log.length();
            }
            if (log.contains(message)) {
                this.LOG.info("Verified integration logs - All values OK!");
                return;
            }
            if (!this.printLogs) {
                this.LOG.warn(String.format("Waiting for integration '%s' to log message - retry in %s ms", integration, this.delayBetweenAttempts));
            }
            try {
                Thread.sleep(this.delayBetweenAttempts);
                continue;
            }
            catch (InterruptedException e) {
                this.LOG.warn("Interrupted while waiting for integration logs", (Throwable)e);
            }
        }
        throw new ActionTimeoutException((long)this.maxAttempts * this.delayBetweenAttempts, (Throwable)new CitrusRuntimeException(String.format("Failed to verify integration '%s' - has not printed message '%s' after %d attempts", integration, message, this.maxAttempts)));
    }

    private Long verifyLocalIntegrationStatus(String integration, String phase, TestContext context) {
        INTEGRATION_STATUS_LOG.info(String.format("Waiting for integration '%s' to be in state '%s'", integration, phase));
        for (int i = 0; i < this.maxAttempts; ++i) {
            if (context.getVariables().containsKey(integration + ":pid")) {
                Long pid = (Long)context.getVariable(integration + ":pid", Long.class);
                Map<String, String> properties = CamelJBang.camel().get(pid);
                if (phase.equals("Stopped") && properties.isEmpty() || !properties.isEmpty() && properties.get("STATUS").equals(phase)) {
                    this.LOG.info(String.format("Verified integration '%s' state '%s' - All values OK!", integration, phase));
                    return pid;
                }
            }
            this.LOG.info(String.format("Waiting for integration '%s' to be in state '%s'- retry in %s ms", integration, phase, this.delayBetweenAttempts));
            try {
                Thread.sleep(this.delayBetweenAttempts);
                continue;
            }
            catch (InterruptedException e) {
                this.LOG.warn("Interrupted while waiting for integration state", (Throwable)e);
            }
        }
        throw new ActionTimeoutException((long)this.maxAttempts * this.delayBetweenAttempts, (Throwable)new CitrusRuntimeException(String.format("Failed to verify integration '%s' - is not in state '%s' after %d attempts", integration, phase, this.maxAttempts)));
    }

    private void verifyIntegration(String namespace, String integration, TestContext context) {
        Pod pod = this.verifyIntegrationPod(integration, context.replaceDynamicContentInString(this.phase), namespace);
        if (this.logMessage != null) {
            this.verifyIntegrationLogs(pod, integration, namespace, context.replaceDynamicContentInString(this.logMessage));
        }
    }

    private void verifyIntegrationLogs(Pod pod, String name, String namespace, String message) {
        if (this.printLogs) {
            INTEGRATION_LOG.info(String.format("Waiting for pod '%s' to log message", name));
        }
        int offset = 0;
        for (int i = 0; i < this.maxAttempts; ++i) {
            String log = this.getIntegrationPodLogs(pod, namespace);
            if (this.printLogs && offset < log.length()) {
                INTEGRATION_LOG.info(log.substring(offset));
                offset = log.length();
            }
            if (log.contains(message)) {
                this.LOG.info("Verified integration logs - All values OK!");
                return;
            }
            if (!this.printLogs) {
                this.LOG.warn(String.format("Waiting for integration '%s' to log message - retry in %s ms", name, this.delayBetweenAttempts));
            }
            try {
                Thread.sleep(this.delayBetweenAttempts);
                continue;
            }
            catch (InterruptedException e) {
                this.LOG.warn("Interrupted while waiting for integration pod logs", (Throwable)e);
            }
        }
        throw new ActionTimeoutException((long)this.maxAttempts * this.delayBetweenAttempts, (Throwable)new CitrusRuntimeException(String.format("Failed to verify integration '%s' - has not printed message '%s' after %d attempts", name, message, this.maxAttempts)));
    }

    private String getIntegrationPodLogs(Pod pod, String namespace) {
        PodResource podRes = (PodResource)((NonNamespaceOperation)this.getKubernetesClient().pods().inNamespace(namespace)).withName(pod.getMetadata().getName());
        String containerName = null;
        if (pod.getSpec() != null && pod.getSpec().getContainers() != null && pod.getSpec().getContainers().size() > 1) {
            containerName = ((Container)pod.getSpec().getContainers().get(0)).getName();
        }
        String logs = containerName != null ? ((ContainerResource)podRes.inContainer(containerName)).getLog() : podRes.getLog();
        return logs;
    }

    private Pod verifyIntegrationPod(String name, String phase, String namespace) {
        INTEGRATION_STATUS_LOG.info(String.format("Waiting for integration '%s' to be in state '%s'", name, phase));
        for (int i = 0; i < this.maxAttempts; ++i) {
            Pod pod = this.getIntegrationPod(name, phase, namespace);
            if (pod != null) {
                this.LOG.info(String.format("Verified integration pod '%s' state '%s' - All values OK!", name, phase));
                return pod;
            }
            this.LOG.info(String.format("Waiting for integration '%s' to be in state '%s'- retry in %s ms", name, phase, this.delayBetweenAttempts));
            try {
                Thread.sleep(this.delayBetweenAttempts);
                continue;
            }
            catch (InterruptedException e) {
                this.LOG.warn("Interrupted while waiting for integration pod state", (Throwable)e);
            }
        }
        throw new ActionTimeoutException((long)this.maxAttempts * this.delayBetweenAttempts, (Throwable)new CitrusRuntimeException(String.format("Failed to verify integration '%s' - is not in state '%s' after %d attempts", name, phase, this.maxAttempts)));
    }

    private Pod getIntegrationPod(String integration, String phase, String namespace) {
        PodList pods = (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.getKubernetesClient().pods().inNamespace(namespace)).withLabel("camel.apache.org/integration", integration)).list();
        if (pods.getItems().isEmpty()) {
            INTEGRATION_STATUS_LOG.info(String.format("Integration '%s' not yet available. Will keep checking ...", integration));
        }
        return pods.getItems().stream().filter(pod -> {
            boolean verified = KubernetesSupport.verifyPodStatus((Pod)pod, (String)phase);
            if (!verified) {
                INTEGRATION_STATUS_LOG.info(String.format("Integration '%s' not yet in state '%s'. Will keep checking ...", integration, phase));
            }
            return verified;
        }).findFirst().orElse(null);
    }

    public static final class Builder
    extends AbstractCamelKAction.Builder<VerifyIntegrationAction, Builder> {
        private String integrationName;
        private String logMessage;
        private int maxAttempts = CamelKSettings.getMaxAttempts();
        private long delayBetweenAttempts = CamelKSettings.getDelayBetweenAttempts();
        private String phase = "Running";
        private boolean printLogs = true;

        public Builder isRunning() {
            this.phase = "Running";
            return this;
        }

        public Builder isStopped() {
            this.phase = "Stopped";
            return this;
        }

        public Builder printLogs(boolean printLogs) {
            this.printLogs = printLogs;
            return this;
        }

        public Builder integrationName(String integrationName) {
            this.integrationName = integrationName;
            return this;
        }

        public Builder waitForLogMessage(String logMessage) {
            this.logMessage = logMessage;
            return this;
        }

        public Builder maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder delayBetweenAttempts(long delayBetweenAttempts) {
            this.delayBetweenAttempts = delayBetweenAttempts;
            return this;
        }

        public VerifyIntegrationAction build() {
            return new VerifyIntegrationAction(this);
        }
    }
}

