/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.actions.kamelet;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Updatable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.yaks.camelk.actions.kamelet.AbstractKameletAction;
import org.citrusframework.yaks.camelk.model.Kamelet;
import org.citrusframework.yaks.camelk.model.KameletList;
import org.citrusframework.yaks.camelk.model.KameletSpec;
import org.citrusframework.yaks.camelk.model.v1alpha1.KameletV1Alpha1;
import org.citrusframework.yaks.camelk.model.v1alpha1.KameletV1Alpha1List;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;
import org.springframework.util.StringUtils;

public class CreateKameletAction
extends AbstractKameletAction {
    private final String name;
    private final String template;
    private final KameletSpec.Source source;
    private final KameletSpec.Definition definition;
    private final List<String> dependencies;
    private final Map<String, KameletSpec.DataTypesSpec> dataTypes;
    private final Resource resource;
    private final boolean supportVariables;

    public CreateKameletAction(Builder builder) {
        super("create-kamelet", builder);
        this.name = builder.name;
        this.template = builder.template;
        this.source = builder.source;
        this.definition = builder.definition;
        this.dependencies = builder.dependencies;
        this.dataTypes = builder.dataTypes;
        this.resource = builder.resource;
        this.supportVariables = builder.supportVariables;
    }

    public void doExecute(TestContext context) {
        this.createKamelet(context);
    }

    private void createKamelet(TestContext context) {
        Kamelet kamelet;
        if (this.resource != null) {
            try {
                String resolvedSource = this.supportVariables ? context.replaceDynamicContentInString(FileUtils.readToString((Resource)this.resource)) : FileUtils.readToString((Resource)this.resource);
                kamelet = (Kamelet)((Object)KubernetesSupport.yaml().loadAs(resolvedSource, Kamelet.class));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException(String.format("Failed to load Kamelet from resource %s", this.name + ".kamelet.yaml"), (Throwable)e);
            }
        } else {
            if (this.definition.getTitle() != null) {
                this.definition.setTitle(context.replaceDynamicContentInString(this.definition.getTitle()));
            }
            if (this.definition.getDescription() != null) {
                this.definition.setDescription(context.replaceDynamicContentInString(this.definition.getDescription()));
            }
            this.definition.setProperties(context.resolveDynamicValuesInMap(this.definition.getProperties()));
            this.definition.setRequired(context.resolveDynamicValuesInList(this.definition.getRequired()));
            Kamelet.Builder builder = new Kamelet.Builder().name(context.replaceDynamicContentInString(this.name)).definition(this.definition);
            if (this.template != null) {
                builder.template(context.replaceDynamicContentInString(this.template));
            }
            if (this.source != null) {
                builder.source(this.source.getName(), context.replaceDynamicContentInString(this.source.getContent()));
            }
            if (this.dependencies != null && !this.dependencies.isEmpty()) {
                builder.dependencies(context.resolveDynamicValuesInList(this.dependencies));
            }
            if (this.dataTypes != null && !this.dataTypes.isEmpty()) {
                builder.dataTypes(context.resolveDynamicValuesInMap(this.dataTypes));
            }
            kamelet = builder.build();
        }
        if (!kamelet.getMetadata().getLabels().containsKey("camel.apache.org/kamelet.type")) {
            if (kamelet.getMetadata().getName().endsWith("-source")) {
                kamelet.getMetadata().getLabels().put("camel.apache.org/kamelet.type", "source");
            } else if (kamelet.getMetadata().getName().endsWith("-sink")) {
                kamelet.getMetadata().getLabels().put("camel.apache.org/kamelet.type", "sink");
            } else if (kamelet.getMetadata().getName().endsWith("-action")) {
                kamelet.getMetadata().getLabels().put("camel.apache.org/kamelet.type", "action");
            } else {
                throw new CitrusRuntimeException(String.format("Unsupported Kamelet type - failed to determine type from Kamelet name %s, expected one of '-source', '-sink' or '-action' suffix", kamelet.getMetadata().getName()));
            }
        }
        if (this.LOG.isDebugEnabled()) {
            try {
                this.LOG.debug(KubernetesSupport.json().writeValueAsString((Object)kamelet));
            }
            catch (JsonProcessingException e) {
                this.LOG.warn("Unable to dump Kamelet data", (Throwable)e);
            }
        }
        if (this.getApiVersion(context).equals("v1alpha1")) {
            KameletV1Alpha1 kameletV1Alpha1 = kamelet instanceof KameletV1Alpha1 ? (KameletV1Alpha1)kamelet : new KameletV1Alpha1.Builder().from(kamelet).build();
            ((io.fabric8.kubernetes.client.dsl.Resource)((NonNamespaceOperation)this.getKubernetesClient().resources(KameletV1Alpha1.class, KameletV1Alpha1List.class).inNamespace(this.kameletNamespace(context))).resource((Object)kameletV1Alpha1)).createOr(Updatable::update);
        } else {
            ((io.fabric8.kubernetes.client.dsl.Resource)((NonNamespaceOperation)this.getKubernetesClient().resources(Kamelet.class, KameletList.class).inNamespace(this.kameletNamespace(context))).resource((Object)kamelet)).createOr(Updatable::update);
        }
        this.LOG.info(String.format("Successfully created Kamelet '%s'", kamelet.getMetadata().getName()));
    }

    public static final class Builder
    extends AbstractKameletAction.Builder<CreateKameletAction, Builder> {
        private String name;
        private String template;
        private KameletSpec.Source source;
        private final List<String> dependencies = new ArrayList<String>();
        private KameletSpec.Definition definition = new KameletSpec.Definition();
        private final Map<String, KameletSpec.DataTypesSpec> dataTypes = new HashMap<String, KameletSpec.DataTypesSpec>();
        private Resource resource;
        private boolean supportVariables = true;

        public Builder supportVariables(boolean supportVariables) {
            this.supportVariables = supportVariables;
            return this;
        }

        public Builder kamelet(String kameletName) {
            this.name = kameletName;
            this.title(StringUtils.capitalize((String)kameletName));
            return this;
        }

        public Builder title(String title) {
            this.definition.setTitle(title);
            return this;
        }

        public Builder source(String name, String language, String content) {
            this.source = new KameletSpec.Source(name + "." + language, content);
            return this;
        }

        public Builder source(String name, String content) {
            this.source = new KameletSpec.Source(name, content);
            return this;
        }

        public Builder template(String template) {
            this.template = template;
            return this;
        }

        @Deprecated
        public Builder flow(String flow) {
            this.template = flow;
            return this;
        }

        public Builder dependencies(String dependencies) {
            this.dependencies.addAll(Arrays.asList(dependencies.split(",")));
            return this;
        }

        public Builder dependencies(List<String> dependencies) {
            this.dependencies.addAll(dependencies);
            return this;
        }

        public Builder dependency(String dependency) {
            this.dependencies.add(dependency);
            return this;
        }

        public Builder definition(KameletSpec.Definition definition) {
            this.definition = definition;
            return this;
        }

        public Builder addProperty(String name, KameletSpec.Definition.PropertyConfig propertyConfig) {
            this.definition.getProperties().put(name, propertyConfig);
            return this;
        }

        public Builder inType(String scheme, String format) {
            return this.addDataType("in", scheme, format);
        }

        public Builder outType(String scheme, String format) {
            return this.addDataType("out", scheme, format);
        }

        public Builder errorType(String scheme, String format) {
            return this.addDataType("error", scheme, format);
        }

        public Builder addDataType(String slot, String scheme, String format) {
            if (this.dataTypes.containsKey(slot)) {
                this.dataTypes.get(slot).getTypes().put(format, new KameletSpec.DataTypeSpec(scheme, format));
            } else {
                this.dataTypes.put(slot, new KameletSpec.DataTypesSpec(format, new KameletSpec.DataTypeSpec(scheme, format)));
            }
            return this;
        }

        public Builder fromBuilder(Kamelet.Builder builder) {
            Kamelet kamelet = builder.build();
            this.name = kamelet.getMetadata().getName();
            this.definition = ((KameletSpec)kamelet.getSpec()).getDefinition();
            this.dependencies.addAll(((KameletSpec)kamelet.getSpec()).getDependencies());
            this.dataTypes.putAll(((KameletSpec)kamelet.getSpec()).getDataTypes());
            if (((KameletSpec)kamelet.getSpec()).getSources() != null && !((KameletSpec)kamelet.getSpec()).getSources().isEmpty()) {
                this.source = ((KameletSpec)kamelet.getSpec()).getSources().get(0);
            }
            if (((KameletSpec)kamelet.getSpec()).getTemplate() != null) {
                this.template = KubernetesSupport.yaml().dumpAsMap(((KameletSpec)kamelet.getSpec()).getTemplate());
            } else if (((KameletSpec)kamelet.getSpec()).getFlow() != null) {
                this.template = KubernetesSupport.yaml().dumpAsMap(((KameletSpec)kamelet.getSpec()).getFlow());
            }
            return this;
        }

        public Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public CreateKameletAction build() {
            return new CreateKameletAction(this);
        }
    }
}

