/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.actions.kamelet;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Updatable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.yaks.YaksClusterType;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.camelk.actions.kamelet.AbstractKameletAction;
import org.citrusframework.yaks.camelk.jbang.CamelJBang;
import org.citrusframework.yaks.camelk.jbang.CamelJBangSettings;
import org.citrusframework.yaks.camelk.jbang.ProcessAndOutput;
import org.citrusframework.yaks.camelk.model.IntegrationSpec;
import org.citrusframework.yaks.camelk.model.Pipe;
import org.citrusframework.yaks.camelk.model.PipeList;
import org.citrusframework.yaks.camelk.model.PipeSpec;
import org.citrusframework.yaks.camelk.model.v1alpha1.KameletBinding;
import org.citrusframework.yaks.camelk.model.v1alpha1.KameletBindingList;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatePipeAction
extends AbstractKameletAction {
    private static final Logger LOG = LoggerFactory.getLogger(CreatePipeAction.class);
    private final String pipeName;
    private final IntegrationSpec integration;
    private final PipeSpec.Endpoint source;
    private final PipeSpec.Endpoint sink;
    private final Resource resource;

    public CreatePipeAction(Builder builder) {
        super("create-pipe", builder);
        this.pipeName = builder.pipeName;
        this.integration = builder.integration;
        this.source = builder.source;
        this.sink = builder.sink;
        this.resource = builder.resource;
    }

    public void doExecute(TestContext context) {
        Pipe pipe;
        String pipeName = context.replaceDynamicContentInString(this.pipeName);
        LOG.info(String.format("Creating Camel K pipe '%s'", pipeName));
        if (this.resource != null) {
            try {
                if (this.getApiVersion(context).equals("v1alpha1")) {
                    pipe = (Pipe)((Object)KubernetesSupport.yaml().loadAs(context.replaceDynamicContentInString(FileUtils.readToString((Resource)this.resource)), KameletBinding.class));
                }
                pipe = (Pipe)((Object)KubernetesSupport.yaml().loadAs(context.replaceDynamicContentInString(FileUtils.readToString((Resource)this.resource)), Pipe.class));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException(String.format("Failed to load pipe from resource %s", pipeName + ".yaml"), (Throwable)e);
            }
        } else {
            Pipe.Builder builder = new Pipe.Builder().name(pipeName);
            if (this.integration != null) {
                builder.integration(this.integration);
            }
            if (this.source != null) {
                this.source.setProperties(context.resolveDynamicValuesInMap(this.source.getProperties()));
                builder.source(this.source);
            }
            if (this.sink != null) {
                if (this.sink.getUri() != null) {
                    this.sink.setUri(context.replaceDynamicContentInString(this.sink.getUri()));
                }
                this.sink.setProperties(context.resolveDynamicValuesInMap(this.sink.getProperties()));
                builder.sink(this.sink);
            }
            pipe = builder.build();
        }
        if (YaksSettings.isLocal((YaksClusterType)this.clusterType(context))) {
            this.createLocalPipe(pipe, pipeName, context);
        } else {
            this.createPipe(this.getKubernetesClient(), this.namespace(context), pipe, context);
        }
        LOG.info(String.format("Successfully created pipe '%s'", pipe.getMetadata().getName()));
    }

    private void createPipe(KubernetesClient k8sClient, String namespace, Pipe pipe, TestContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(KubernetesSupport.yaml().dumpAsMap((Object)pipe));
        }
        if (this.getApiVersion(context).equals("v1alpha1")) {
            KameletBinding kb = pipe instanceof KameletBinding ? (KameletBinding)pipe : new KameletBinding.Builder().from(pipe).build();
            ((io.fabric8.kubernetes.client.dsl.Resource)((NonNamespaceOperation)k8sClient.resources(KameletBinding.class, KameletBindingList.class).inNamespace(namespace)).resource((Object)kb)).createOr(Updatable::update);
        } else {
            ((io.fabric8.kubernetes.client.dsl.Resource)((NonNamespaceOperation)k8sClient.resources(Pipe.class, PipeList.class).inNamespace(namespace)).resource((Object)pipe)).createOr(Updatable::update);
        }
    }

    private void createLocalPipe(Pipe pipe, String name, TestContext context) {
        try {
            String pipeYaml;
            if (this.getApiVersion(context).equals("v1alpha1")) {
                KameletBinding kb = pipe instanceof KameletBinding ? (KameletBinding)pipe : new KameletBinding.Builder().from(pipe).build();
                pipeYaml = KubernetesSupport.yaml().dumpAsMap((Object)kb);
            } else {
                pipeYaml = KubernetesSupport.yaml().dumpAsMap((Object)pipe);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(pipeYaml);
            }
            Path workDir = CamelJBangSettings.getWorkDir();
            Files.createDirectories(workDir, new FileAttribute[0]);
            Path file = workDir.resolve(String.format("i-%s.yaml", name));
            Files.write(file, pipeYaml.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            ProcessAndOutput pao = CamelJBang.camel().run(name, file, new String[0]);
            if (!pao.getProcess().isAlive()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(pao.getOutput());
                }
                throw new CitrusRuntimeException(String.format("Failed to create pipe - exit code %s", pao.getProcess().exitValue()));
            }
            Long pid = pao.getCamelProcessId();
            context.setVariable(name + ":pid", (Object)pid);
            context.setVariable(name + ":process:" + pid, (Object)pao);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to create pipe file", (Throwable)e);
        }
    }

    public static final class Builder
    extends AbstractKameletAction.Builder<CreatePipeAction, Builder> {
        private String pipeName;
        private IntegrationSpec integration;
        private PipeSpec.Endpoint source;
        private PipeSpec.Endpoint sink;
        private Resource resource;

        public Builder binding(String pipeName) {
            this.apiVersion("v1alpha1");
            this.pipeName = pipeName;
            return this;
        }

        public Builder pipe(String pipeName) {
            this.pipeName = pipeName;
            return this;
        }

        public Builder integration(IntegrationSpec integration) {
            this.integration = integration;
            return this;
        }

        public Builder source(PipeSpec.Endpoint source) {
            this.source = source;
            return this;
        }

        public Builder source(String uri) {
            return this.source(new PipeSpec.Endpoint(uri));
        }

        public Builder source(PipeSpec.Endpoint.ObjectReference ref, String properties) {
            Map props = null;
            if (properties != null && !properties.isEmpty()) {
                props = (Map)KubernetesSupport.yaml().load(properties);
            }
            return this.source(new PipeSpec.Endpoint(ref, props));
        }

        public Builder sink(PipeSpec.Endpoint sink) {
            this.sink = sink;
            return this;
        }

        public Builder sink(String uri) {
            return this.sink(new PipeSpec.Endpoint(uri));
        }

        public Builder sink(PipeSpec.Endpoint.ObjectReference ref, String properties) {
            Map props = null;
            if (properties != null && !properties.isEmpty()) {
                props = (Map)KubernetesSupport.yaml().load(properties);
            }
            return this.sink(new PipeSpec.Endpoint(ref, props));
        }

        public Builder fromBuilder(Pipe.Builder builder) {
            Pipe pipe = builder.build();
            this.pipeName = pipe.getMetadata().getName();
            this.integration = ((PipeSpec)pipe.getSpec()).getIntegration();
            this.source = ((PipeSpec)pipe.getSpec()).getSource();
            this.sink = ((PipeSpec)pipe.getSpec()).getSink();
            return this;
        }

        public Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public CreatePipeAction build() {
            return new CreatePipeAction(this);
        }
    }
}

