/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.camelk.actions.kamelet;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.yaks.YaksClusterType;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.camelk.actions.kamelet.AbstractKameletAction;
import org.citrusframework.yaks.camelk.jbang.CamelJBang;
import org.citrusframework.yaks.camelk.model.Pipe;
import org.citrusframework.yaks.camelk.model.PipeList;
import org.citrusframework.yaks.camelk.model.v1alpha1.KameletBinding;
import org.citrusframework.yaks.camelk.model.v1alpha1.KameletBindingList;

public class DeletePipeAction
extends AbstractKameletAction {
    private final String pipeName;

    public DeletePipeAction(Builder builder) {
        super("delete-pipe", builder);
        this.pipeName = builder.pipeName;
    }

    public void doExecute(TestContext context) {
        String pipe = context.replaceDynamicContentInString(this.pipeName);
        this.LOG.info(String.format("Deleting pipe '%s'", pipe));
        if (YaksSettings.isLocal((YaksClusterType)this.clusterType(context))) {
            DeletePipeAction.deleteLocalBinding(pipe, context);
        } else {
            this.deleteBinding(this.getKubernetesClient(), this.namespace(context), pipe, context);
        }
        this.LOG.info(String.format("Successfully deleted pipe '%s'", pipe));
    }

    private void deleteBinding(KubernetesClient k8sClient, String namespace, String name, TestContext context) {
        if (this.getApiVersion(context).equals("v1alpha1")) {
            ((Resource)((NonNamespaceOperation)k8sClient.resources(KameletBinding.class, KameletBindingList.class).inNamespace(namespace)).withName(name)).delete();
        } else {
            ((Resource)((NonNamespaceOperation)k8sClient.resources(Pipe.class, PipeList.class).inNamespace(namespace)).withName(name)).delete();
        }
    }

    private static void deleteLocalBinding(String name, TestContext context) {
        Long pid = context.getVariables().containsKey(name + ":pid") ? (Long)context.getVariable(name + ":pid", Long.class) : CamelJBang.camel().getAll().stream().filter(props -> name.equals(props.get("NAME")) && !props.getOrDefault("PID", "").isBlank()).map(props -> Long.valueOf((String)props.get("PID"))).findFirst().orElseThrow(() -> new CitrusRuntimeException(String.format("Unable to retrieve pipe process id %s:pid", name)));
        CamelJBang.camel().stop(pid);
    }

    public static class Builder
    extends AbstractKameletAction.Builder<DeletePipeAction, Builder> {
        private String pipeName;

        public Builder binding(String name) {
            this.apiVersion("v1alpha1");
            this.pipeName = name;
            return this;
        }

        public Builder pipe(String name) {
            this.pipeName = name;
            return this;
        }

        public DeletePipeAction build() {
            return new DeletePipeAction(this);
        }
    }
}

